"""
Snowflake Artifact Repository API.

The Snowflake Artifact Repository API is a REST API that you can use to access, update, and perform certain actions on Artifact Repository resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated


class ArtifactRepository(BaseModel):
    """A model object representing the ArtifactRepository resource.

    Constructs an object of type ArtifactRepository with the provided properties.

    Parameters
    __________
    name : str
        Name of the artifact repository
    type : str
        Specifies the type of the repository. The only current supported option is ‘PIP’.
    api_integration : str
        Link to an integration object
    comment : str, optional
        user comment associated to an object in the dictionary
    created_on : datetime, optional
        Date and time when the artifact repository was created — **Read-only:** *any user-provided value will be ignored.*
    database_name : str, optional
        Database in which the artifact repository is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the artifact repository is stored — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the artifact repository — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the artifact repository — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Annotated[str, Field(strict=True)]

    type: StrictStr

    comment: Optional[StrictStr] = None

    api_integration: StrictStr

    created_on: Optional[datetime] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = [
        "name",
        "type",
        "comment",
        "api_integration",
        "created_on",
        "database_name",
        "schema_name",
        "owner",
        "owner_role_type",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v not in ("PIP"):
            raise ValueError("must validate the enum values ('PIP')")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner_role_type")
    def owner_role_type_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ArtifactRepository:
        """Create an instance of ArtifactRepository from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "owner",
                    "owner_role_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ArtifactRepository:
        """Create an instance of ArtifactRepository from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ArtifactRepository.model_validate(obj)

        _obj = ArtifactRepository.model_validate(
            {
                "name": obj.get("name"),
                "type": obj.get("type"),
                "comment": obj.get("comment"),
                "api_integration": obj.get("api_integration"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
            }
        )

        return _obj


class ArtifactRepositoryModel:
    def __init__(
        self,
        name: str,
        type: str,
        api_integration: str,
        # optional properties
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the ArtifactRepository resource.

        Constructs an object of type ArtifactRepository with the provided properties.

        Parameters
        __________
        name : str
            Name of the artifact repository
        type : str
            Specifies the type of the repository. The only current supported option is ‘PIP’.
        api_integration : str
            Link to an integration object
        comment : str, optional
            user comment associated to an object in the dictionary
        created_on : datetime, optional
            Date and time when the artifact repository was created.
        database_name : str, optional
            Database in which the artifact repository is stored
        schema_name : str, optional
            Schema in which the artifact repository is stored
        owner : str, optional
            Role that owns the artifact repository
        owner_role_type : str, optional
            The type of role that owns the artifact repository
        """
        self.name = name
        self.type = type
        self.comment = comment
        self.api_integration = api_integration
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = [
        "name",
        "type",
        "comment",
        "api_integration",
        "created_on",
        "database_name",
        "schema_name",
        "owner",
        "owner_role_type",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ArtifactRepository(
            name=self.name,
            type=self.type,
            comment=self.comment,
            api_integration=self.api_integration,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> ArtifactRepositoryModel:
        return ArtifactRepositoryModel(
            name=model.name,
            type=model.type,
            comment=model.comment,
            api_integration=model.api_integration,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ArtifactRepository.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ArtifactRepository object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ArtifactRepositoryModel:
        """Create an instance of ArtifactRepository from a dict.

        This method constructs a ArtifactRepository object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ArtifactRepository
            A ArtifactRepository object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ArtifactRepository.from_dict(obj))


ArtifactRepository._model_class = ArtifactRepositoryModel
