"""
Snowflake Catalog Integration API.

The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, ConfigDict, StrictStr


class RestConfig(BaseModel):
    """A model object representing the RestConfig resource.

    Constructs an object of type RestConfig with the provided properties.

    Parameters
    __________
    catalog_uri : str
        Customer's Polaris account locator URL
    warehouse : str
        Name of the catalog to use in Polaris
    """

    catalog_uri: StrictStr

    warehouse: StrictStr

    __properties = ["catalog_uri", "warehouse"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RestConfig:
        """Create an instance of RestConfig from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> RestConfig:
        """Create an instance of RestConfig from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RestConfig.model_validate(obj)

        _obj = RestConfig.model_validate(
            {
                "catalog_uri": obj.get("catalog_uri"),
                "warehouse": obj.get("warehouse"),
            }
        )

        return _obj


class RestConfigModel:
    def __init__(
        self,
        catalog_uri: str,
        warehouse: str,
        # optional properties
    ):
        """A model object representing the RestConfig resource.

        Constructs an object of type RestConfig with the provided properties.

        Parameters
        __________
        catalog_uri : str
            Customer's Polaris account locator URL
        warehouse : str
            Name of the catalog to use in Polaris
        """
        self.catalog_uri = catalog_uri
        self.warehouse = warehouse

    __properties = ["catalog_uri", "warehouse"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return RestConfig(
            catalog_uri=self.catalog_uri,
            warehouse=self.warehouse,
        )

    @classmethod
    def _from_model(cls, model) -> RestConfigModel:
        return RestConfigModel(
            catalog_uri=model.catalog_uri,
            warehouse=model.warehouse,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a RestConfig.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the RestConfig object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> RestConfigModel:
        """Create an instance of RestConfig from a dict.

        This method constructs a RestConfig object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        RestConfig
            A RestConfig object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(RestConfig.from_dict(obj))


RestConfig._model_class = RestConfigModel
