"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.semantic_model_update_suggestion import (
    SemanticModelUpdateSuggestion,
    SemanticModelUpdateSuggestionModel,
)
from snowflake.core.cortex.analyst_service._generated.models.warning import Warning, WarningModel


class GenerateFiltersAndMetricsSuggestionsResponse(BaseModel):
    """A model object representing the GenerateFiltersAndMetricsSuggestionsResponse resource.

    Constructs an object of type GenerateFiltersAndMetricsSuggestionsResponse with the provided properties.

    Parameters
    __________
    request_id : str, optional
        Unique request ID
    suggestions : list[SemanticModelUpdateSuggestion], optional

    warnings : list[Warning], optional

    experimental : str, optional
        JSON serialized string of experimental API fields (undocumented).
    """

    request_id: Optional[StrictStr] = None

    suggestions: Optional[List[SemanticModelUpdateSuggestion]] = None

    warnings: Optional[List[Warning]] = None

    experimental: Optional[StrictStr] = None

    __properties = ["request_id", "suggestions", "warnings", "experimental"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GenerateFiltersAndMetricsSuggestionsResponse:
        """Create an instance of GenerateFiltersAndMetricsSuggestionsResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in suggestions (list)
        _items = []
        if self.suggestions:
            for _item in self.suggestions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["suggestions"] = _items

        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict["warnings"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateFiltersAndMetricsSuggestionsResponse:
        """Create an instance of GenerateFiltersAndMetricsSuggestionsResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GenerateFiltersAndMetricsSuggestionsResponse.model_validate(obj)

        _obj = GenerateFiltersAndMetricsSuggestionsResponse.model_validate(
            {
                "request_id": obj.get("request_id"),
                "suggestions": [SemanticModelUpdateSuggestion.from_dict(_item) for _item in obj.get("suggestions")]
                if obj.get("suggestions") is not None
                else None,
                "warnings": [Warning.from_dict(_item) for _item in obj.get("warnings")]
                if obj.get("warnings") is not None
                else None,
                "experimental": obj.get("experimental"),
            }
        )

        return _obj


class GenerateFiltersAndMetricsSuggestionsResponseModel:
    def __init__(
        self,  # optional properties
        request_id: Optional[str] = None,
        suggestions: Optional[list[SemanticModelUpdateSuggestion]] = None,
        warnings: Optional[list[Warning]] = None,
        experimental: Optional[str] = None,
    ):
        """A model object representing the GenerateFiltersAndMetricsSuggestionsResponse resource.

        Constructs an object of type GenerateFiltersAndMetricsSuggestionsResponse with the provided properties.

        Parameters
        __________
        request_id : str, optional
            Unique request ID
        suggestions : list[SemanticModelUpdateSuggestion], optional

        warnings : list[Warning], optional

        experimental : str, optional
            JSON serialized string of experimental API fields (undocumented).
        """
        self.request_id = request_id
        self.suggestions = suggestions
        self.warnings = warnings
        self.experimental = experimental

    __properties = ["request_id", "suggestions", "warnings", "experimental"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GenerateFiltersAndMetricsSuggestionsResponse(
            request_id=self.request_id,
            suggestions=[x._to_model() for x in self.suggestions] if self.suggestions is not None else None,
            warnings=[x._to_model() for x in self.warnings] if self.warnings is not None else None,
            experimental=self.experimental,
        )

    @classmethod
    def _from_model(cls, model) -> GenerateFiltersAndMetricsSuggestionsResponseModel:
        return GenerateFiltersAndMetricsSuggestionsResponseModel(
            request_id=model.request_id,
            suggestions=[SemanticModelUpdateSuggestionModel._from_model(x) for x in model.suggestions]
            if model.suggestions
            else None,
            warnings=[WarningModel._from_model(x) for x in model.warnings] if model.warnings else None,
            experimental=model.experimental,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GenerateFiltersAndMetricsSuggestionsResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GenerateFiltersAndMetricsSuggestionsResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateFiltersAndMetricsSuggestionsResponseModel:
        """Create an instance of GenerateFiltersAndMetricsSuggestionsResponse from a dict.

        This method constructs a GenerateFiltersAndMetricsSuggestionsResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GenerateFiltersAndMetricsSuggestionsResponse
            A GenerateFiltersAndMetricsSuggestionsResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GenerateFiltersAndMetricsSuggestionsResponse.from_dict(obj))


GenerateFiltersAndMetricsSuggestionsResponse._model_class = GenerateFiltersAndMetricsSuggestionsResponseModel
