"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, ClassVar, Dict, Optional, Union

from pydantic import BaseModel, ConfigDict, StrictInt

import snowflake.core.cortex.analyst_service._generated.models

from snowflake.core.cortex.analyst_service._generated.models import *  # noqa: F403


class MessageContentDelta(BaseModel):
    """A model object representing the MessageContentDelta resource.

    Constructs an object of type MessageContentDelta with the provided properties.

    Parameters
    __________
    index : int, optional
        The index of the content array this delta object represents
    """

    index: Optional[StrictInt] = None

    __properties = ["type", "index"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "chart": "MessageContentChartObject",
        "sql": "MessageContentDeltaSqlObject",
        "suggestions": "MessageContentDeltaSuggestionsObject",
        "text": "MessageContentDeltaTextObject",
        "think": "MessageContentDeltaThinkObject",
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data."""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    __discriminator_value_to_type: ClassVar[Dict[str, str]] = {
        "MessageContentChartObject": "chart",
        "MessageContentDeltaSqlObject": "sql",
        "MessageContentDeltaSuggestionsObject": "suggestions",
        "MessageContentDeltaTextObject": "text",
        "MessageContentDeltaThinkObject": "think",
    }

    @classmethod
    def get_child_model_discriminator_value(cls, child_model: str) -> str:
        return cls.__discriminator_value_to_type[child_model]

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(
        cls, json_str: str
    ) -> Union[
        MessageContentDeltaSqlObject,
        MessageContentDeltaSuggestionsObject,
        MessageContentDeltaTextObject,
        MessageContentDeltaThinkObject,
    ]:
        """Create an instance of MessageContentDelta from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        MessageContentDeltaSqlObject,
        MessageContentDeltaSuggestionsObject,
        MessageContentDeltaTextObject,
        MessageContentDeltaThinkObject,
    ]:
        """Create an instance of MessageContentDelta from a dict."""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(snowflake.core.cortex.analyst_service._generated.models, object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError(
                "MessageContentDelta failed to lookup discriminator value from "
                + json.dumps(obj)
                + ". Discriminator property name: "
                + cls.__discriminator_property_name
                + ", mapping: "
                + json.dumps(cls.__discriminator_value_class_map)
            )


class MessageContentDeltaModel:
    def __init__(
        self,  # optional properties
        index: Optional[int] = None,
    ):
        """A model object representing the MessageContentDelta resource.

        Constructs an object of type MessageContentDelta with the provided properties.

        Parameters
        __________
        index : int, optional
            The index of the content array this delta object represents
        """
        self.index = index

    __properties = ["type", "index"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentDelta(
            index=self.index,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentDeltaModel:
        return model.__class__._model_class._from_model(model)

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentDelta.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentDelta object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(
        cls, obj: dict
    ) -> Union[
        MessageContentDeltaSqlObjectModel,
        MessageContentDeltaSuggestionsObjectModel,
        MessageContentDeltaTextObjectModel,
        MessageContentDeltaThinkObjectModel,
    ]:
        """Create an instance of MessageContentDelta from a dict.

        This method constructs a MessageContentDelta object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentDelta
            A MessageContentDelta object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentDelta.from_dict(obj))


MessageContentDelta._model_class = MessageContentDeltaModel
