"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.message_content_delta import (
    MessageContentDelta,
)


class MessageContentDeltaThinkObject(MessageContentDelta):
    """A model object representing the MessageContentDeltaThinkObject resource.

    Constructs an object of type MessageContentDeltaThinkObject with the provided properties.

    Parameters
    __________
    think_delta : str
        The delta of the think content, clients should concatenate all deltas for the same index

    index : int, optional
        The index of the content array this delta object represents
    """

    think_delta: StrictStr

    __properties = ["type", "index", "think_delta"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentDeltaThinkObject:
        """Create an instance of MessageContentDeltaThinkObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["type"] = MessageContentDelta.get_child_model_discriminator_value("MessageContentDeltaThinkObject")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentDeltaThinkObject:
        """Create an instance of MessageContentDeltaThinkObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentDeltaThinkObject.model_validate(obj)

        _obj = MessageContentDeltaThinkObject.model_validate(
            {
                "index": obj.get("index"),
                "think_delta": obj.get("think_delta"),
            }
        )

        return _obj


class MessageContentDeltaThinkObjectModel(MessageContentDelta):
    def __init__(
        self,
        think_delta: str,
        # optional properties
        index: Optional[int] = None,
    ):
        """A model object representing the MessageContentDeltaThinkObject resource.

        Constructs an object of type MessageContentDeltaThinkObject with the provided properties.

        Parameters
        __________
        think_delta : str
            The delta of the think content, clients should concatenate all deltas for the same index

        index : int, optional
            The index of the content array this delta object represents
        """
        super().__init__(
            index=index,
        )
        self.think_delta = think_delta

    __properties = ["type", "index", "think_delta"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentDeltaThinkObject(
            index=self.index,
            think_delta=self.think_delta,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentDeltaThinkObjectModel:
        return MessageContentDeltaThinkObjectModel(
            index=model.index,
            think_delta=model.think_delta,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentDeltaThinkObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentDeltaThinkObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentDeltaThinkObjectModel:
        """Create an instance of MessageContentDeltaThinkObject from a dict.

        This method constructs a MessageContentDeltaThinkObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentDeltaThinkObject
            A MessageContentDeltaThinkObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentDeltaThinkObject.from_dict(obj))


MessageContentDeltaThinkObject._model_class = MessageContentDeltaThinkObjectModel
