"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.confidence import Confidence, ConfidenceModel
from snowflake.core.cortex.analyst_service._generated.models.message_content import MessageContent


class MessageContentSqlObject(MessageContent):
    """A model object representing the MessageContentSqlObject resource.

    Constructs an object of type MessageContentSqlObject with the provided properties.

    Parameters
    __________
    statement : str
        The executable SQL statement
    confidence : Confidence, optional
    """

    statement: StrictStr

    confidence: Optional[Confidence] = None

    __properties = ["type", "statement", "confidence"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MessageContentSqlObject:
        """Create an instance of MessageContentSqlObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of confidence
        if self.confidence:
            _dict["confidence"] = self.confidence.to_dict()

        _dict["type"] = MessageContent.get_child_model_discriminator_value("MessageContentSqlObject")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentSqlObject:
        """Create an instance of MessageContentSqlObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MessageContentSqlObject.model_validate(obj)

        _obj = MessageContentSqlObject.model_validate(
            {
                "statement": obj.get("statement"),
                "confidence": Confidence.from_dict(obj.get("confidence"))
                if obj.get("confidence") is not None
                else None,
            }
        )

        return _obj


class MessageContentSqlObjectModel(MessageContent):
    def __init__(
        self,
        statement: str,
        # optional properties
        confidence: Optional[Confidence] = None,
    ):
        """A model object representing the MessageContentSqlObject resource.

        Constructs an object of type MessageContentSqlObject with the provided properties.

        Parameters
        __________
        statement : str
            The executable SQL statement
        confidence : Confidence, optional
        """
        super().__init__()
        self.statement = statement
        self.confidence = confidence

    __properties = ["type", "statement", "confidence"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return MessageContentSqlObject(
            statement=self.statement,
            confidence=self.confidence._to_model() if self.confidence is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> MessageContentSqlObjectModel:
        return MessageContentSqlObjectModel(
            statement=model.statement,
            confidence=ConfidenceModel._from_model(model.confidence) if model.confidence else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a MessageContentSqlObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the MessageContentSqlObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> MessageContentSqlObjectModel:
        """Create an instance of MessageContentSqlObject from a dict.

        This method constructs a MessageContentSqlObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        MessageContentSqlObject
            A MessageContentSqlObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(MessageContentSqlObject.from_dict(obj))


MessageContentSqlObject._model_class = MessageContentSqlObjectModel
