"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.analyst_service._generated.models.semantic_model_change_operation import (
    SemanticModelChangeOperation,
)


class SemanticModelChange(BaseModel):
    """A model object representing the SemanticModelChange resource.

    Constructs an object of type SemanticModelChange with the provided properties.

    Parameters
    __________
    operation : SemanticModelChangeOperation

    path : str
        Path to the node in the semantic object to change
    value : object, optional
        One-of value. A map with exactly one key set corresponding to the semantic model object or primitive.
    """

    operation: SemanticModelChangeOperation

    path: StrictStr

    value: Optional[Dict[str, Any]] = None

    __properties = ["operation", "path", "value"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SemanticModelChange:
        """Create an instance of SemanticModelChange from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelChange:
        """Create an instance of SemanticModelChange from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SemanticModelChange.model_validate(obj)

        _obj = SemanticModelChange.model_validate(
            {
                "operation": obj.get("operation"),
                "path": obj.get("path"),
                "value": obj.get("value"),
            }
        )

        return _obj


class SemanticModelChangeModel:
    def __init__(
        self,
        operation: SemanticModelChangeOperation,
        path: str,
        # optional properties
        value: Optional[object] = None,
    ):
        """A model object representing the SemanticModelChange resource.

        Constructs an object of type SemanticModelChange with the provided properties.

        Parameters
        __________
        operation : SemanticModelChangeOperation

        path : str
            Path to the node in the semantic object to change
        value : object, optional
            One-of value. A map with exactly one key set corresponding to the semantic model object or primitive.
        """
        self.operation = operation
        self.path = path
        self.value = value

    __properties = ["operation", "path", "value"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SemanticModelChange(
            operation=self.operation,
            path=self.path,
            value=self.value,
        )

    @classmethod
    def _from_model(cls, model) -> SemanticModelChangeModel:
        return SemanticModelChangeModel(
            operation=model.operation,
            path=model.path,
            value=model.value,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SemanticModelChange.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SemanticModelChange object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelChangeModel:
        """Create an instance of SemanticModelChange from a dict.

        This method constructs a SemanticModelChange object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SemanticModelChange
            A SemanticModelChange object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SemanticModelChange.from_dict(obj))


SemanticModelChange._model_class = SemanticModelChangeModel
