"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictInt

from snowflake.core.cortex.analyst_service._generated.models.semantic_model_change import (
    SemanticModelChange,
    SemanticModelChangeModel,
)


class SemanticModelUpdateSuggestion(BaseModel):
    """A model object representing the SemanticModelUpdateSuggestion resource.

    Constructs an object of type SemanticModelUpdateSuggestion with the provided properties.

    Parameters
    __________
    changes : list[SemanticModelChange], optional
        Changes to be applied in order
    version : int, optional
        Version of SemanticModelUpdateSuggestion
    """

    changes: Optional[List[SemanticModelChange]] = None

    version: Optional[StrictInt] = None

    __properties = ["changes", "version"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SemanticModelUpdateSuggestion:
        """Create an instance of SemanticModelUpdateSuggestion from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in changes (list)
        _items = []
        if self.changes:
            for _item in self.changes:
                if _item:
                    _items.append(_item.to_dict())
            _dict["changes"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelUpdateSuggestion:
        """Create an instance of SemanticModelUpdateSuggestion from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SemanticModelUpdateSuggestion.model_validate(obj)

        _obj = SemanticModelUpdateSuggestion.model_validate(
            {
                "changes": [SemanticModelChange.from_dict(_item) for _item in obj.get("changes")]
                if obj.get("changes") is not None
                else None,
                "version": obj.get("version"),
            }
        )

        return _obj


class SemanticModelUpdateSuggestionModel:
    def __init__(
        self,  # optional properties
        changes: Optional[list[SemanticModelChange]] = None,
        version: Optional[int] = None,
    ):
        """A model object representing the SemanticModelUpdateSuggestion resource.

        Constructs an object of type SemanticModelUpdateSuggestion with the provided properties.

        Parameters
        __________
        changes : list[SemanticModelChange], optional
            Changes to be applied in order
        version : int, optional
            Version of SemanticModelUpdateSuggestion
        """
        self.changes = changes
        self.version = version

    __properties = ["changes", "version"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SemanticModelUpdateSuggestion(
            changes=[x._to_model() for x in self.changes] if self.changes is not None else None,
            version=self.version,
        )

    @classmethod
    def _from_model(cls, model) -> SemanticModelUpdateSuggestionModel:
        return SemanticModelUpdateSuggestionModel(
            changes=[SemanticModelChangeModel._from_model(x) for x in model.changes] if model.changes else None,
            version=model.version,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SemanticModelUpdateSuggestion.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SemanticModelUpdateSuggestion object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelUpdateSuggestionModel:
        """Create an instance of SemanticModelUpdateSuggestion from a dict.

        This method constructs a SemanticModelUpdateSuggestion object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SemanticModelUpdateSuggestion
            A SemanticModelUpdateSuggestion object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SemanticModelUpdateSuggestion.from_dict(obj))


SemanticModelUpdateSuggestion._model_class = SemanticModelUpdateSuggestionModel
