"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, ConfigDict, Field, StrictStr


class StagingData(BaseModel):
    """A model object representing the StagingData resource.

    Constructs an object of type StagingData with the provided properties.

    Parameters
    __________
    database : str
        Database name
    var_schema : str
        Schema name
    """

    database: StrictStr

    var_schema: StrictStr = Field(alias="schema")

    __properties = ["database", "schema"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagingData:
        """Create an instance of StagingData from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StagingData:
        """Create an instance of StagingData from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StagingData.model_validate(obj)

        _obj = StagingData.model_validate(
            {
                "database": obj.get("database"),
                "var_schema": obj.get("schema"),
            }
        )

        return _obj


class StagingDataModel:
    def __init__(
        self,
        database: str,
        var_schema: str,
        # optional properties
    ):
        """A model object representing the StagingData resource.

        Constructs an object of type StagingData with the provided properties.

        Parameters
        __________
        database : str
            Database name
        var_schema : str
            Schema name
        """
        self.database = database
        self.var_schema = var_schema

    __properties = ["database", "schema"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StagingData(
            database=self.database,
            var_schema=self.var_schema,
        )

    @classmethod
    def _from_model(cls, model) -> StagingDataModel:
        return StagingDataModel(
            database=model.database,
            var_schema=model.var_schema,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StagingData.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StagingData object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StagingDataModel:
        """Create an instance of StagingData from a dict.

        This method constructs a StagingData object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StagingData
            A StagingData object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StagingData.from_dict(obj))


StagingData._model_class = StagingDataModel
