"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict

from snowflake.core.cortex.inference_service._generated.models.anthropic_thinking import (
    AnthropicThinking,
    AnthropicThinkingModel,
)


class AnthropicOutput(BaseModel):
    """A model object representing the AnthropicOutput resource.

    Constructs an object of type AnthropicOutput with the provided properties.

    Parameters
    __________
    thinking : AnthropicThinking, optional
    """

    thinking: Optional[AnthropicThinking] = None

    __properties = ["thinking"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnthropicOutput:
        """Create an instance of AnthropicOutput from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of thinking
        if self.thinking:
            _dict["thinking"] = self.thinking.to_dict()

        # set to None if thinking (nullable) is None
        if self.thinking is None:
            _dict["thinking"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AnthropicOutput:
        """Create an instance of AnthropicOutput from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AnthropicOutput.model_validate(obj)

        _obj = AnthropicOutput.model_validate(
            {
                "thinking": AnthropicThinking.from_dict(obj.get("thinking"))
                if obj.get("thinking") is not None
                else None,
            }
        )

        return _obj


class AnthropicOutputModel:
    def __init__(
        self,  # optional properties
        thinking: Optional[AnthropicThinking] = None,
    ):
        """A model object representing the AnthropicOutput resource.

        Constructs an object of type AnthropicOutput with the provided properties.

        Parameters
        __________
        thinking : AnthropicThinking, optional
        """
        self.thinking = thinking

    __properties = ["thinking"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AnthropicOutput(
            thinking=self.thinking._to_model() if self.thinking is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> AnthropicOutputModel:
        return AnthropicOutputModel(
            thinking=AnthropicThinkingModel._from_model(model.thinking) if model.thinking else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AnthropicOutput.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AnthropicOutput object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AnthropicOutputModel:
        """Create an instance of AnthropicOutput from a dict.

        This method constructs a AnthropicOutput object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AnthropicOutput
            A AnthropicOutput object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AnthropicOutput.from_dict(obj))


AnthropicOutput._model_class = AnthropicOutputModel
