"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class CompleteRequestMessagesInner(BaseModel):
    """A model object representing the CompleteRequestMessagesInner resource.

    Constructs an object of type CompleteRequestMessagesInner with the provided properties.

    Parameters
    __________
    role : str,  default 'user'
        Indicates the role of the message, one of 'system', 'user' or 'assistant'.

        Rules:
          - A 'user' message must be the last message in the list.
          - If a 'system' message is specified, it must be the first message.
          - If a 'assistant' message is specified, it must be immediately before a 'user' message in the list.

        Multiple 'assistant' and 'user' messages can be specified, but they must alternate in sequence.
    content : str, optional
        The text completion prompt, e.g. 'What is a Large Language Model?'.
    content_list : list[object], optional
        Contents of text, toolUse, toolResults, or model-specific output
    """

    role: Optional[StrictStr] = "user"

    content: Optional[StrictStr] = None

    content_list: Optional[List[Any]] = None

    __properties = ["role", "content", "content_list"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRequestMessagesInner:
        """Create an instance of CompleteRequestMessagesInner from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestMessagesInner:
        """Create an instance of CompleteRequestMessagesInner from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompleteRequestMessagesInner.model_validate(obj)

        _obj = CompleteRequestMessagesInner.model_validate(
            {
                "role": obj.get("role") if obj.get("role") is not None else "user",
                "content": obj.get("content"),
                "content_list": obj.get("content_list"),
            }
        )

        return _obj


class CompleteRequestMessagesInnerModel:
    def __init__(
        self,  # optional properties
        role: Optional[str] = "user",
        content: Optional[str] = None,
        content_list: Optional[list[object]] = None,
    ):
        """A model object representing the CompleteRequestMessagesInner resource.

                Constructs an object of type CompleteRequestMessagesInner with the provided properties.

                Parameters
                __________
                role : str,  default 'user'
                    Indicates the role of the message, one of 'system', 'user' or 'assistant'.

        Rules:
          - A 'user' message must be the last message in the list.
          - If a 'system' message is specified, it must be the first message.
          - If a 'assistant' message is specified, it must be immediately before a 'user' message in the list.

        Multiple 'assistant' and 'user' messages can be specified, but they must alternate in sequence.

                content : str, optional
                    The text completion prompt, e.g. 'What is a Large Language Model?'.
                content_list : list[object], optional
                    Contents of text, toolUse, toolResults, or model-specific output
        """
        self.role = role
        self.content = content
        self.content_list = content_list

    __properties = ["role", "content", "content_list"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CompleteRequestMessagesInner(
            role=self.role,
            content=self.content,
            content_list=self.content_list,
        )

    @classmethod
    def _from_model(cls, model) -> CompleteRequestMessagesInnerModel:
        return CompleteRequestMessagesInnerModel(
            role=model.role,
            content=model.content,
            content_list=model.content_list,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CompleteRequestMessagesInner.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CompleteRequestMessagesInner object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestMessagesInnerModel:
        """Create an instance of CompleteRequestMessagesInner from a dict.

        This method constructs a CompleteRequestMessagesInner object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CompleteRequestMessagesInner
            A CompleteRequestMessagesInner object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CompleteRequestMessagesInner.from_dict(obj))


CompleteRequestMessagesInner._model_class = CompleteRequestMessagesInnerModel
