"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict

from snowflake.core.cortex.inference_service._generated.models.complete_request_openai_reasoning import (
    CompleteRequestOpenaiReasoning,
    CompleteRequestOpenaiReasoningModel,
)


class CompleteRequestOpenai(BaseModel):
    """A model object representing the CompleteRequestOpenai resource.

    Constructs an object of type CompleteRequestOpenai with the provided properties.

    Parameters
    __________
    reasoning : CompleteRequestOpenaiReasoning, optional
    """

    reasoning: Optional[CompleteRequestOpenaiReasoning] = None

    __properties = ["reasoning"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CompleteRequestOpenai:
        """Create an instance of CompleteRequestOpenai from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of reasoning
        if self.reasoning:
            _dict["reasoning"] = self.reasoning.to_dict()

        # set to None if reasoning (nullable) is None
        if self.reasoning is None:
            _dict["reasoning"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestOpenai:
        """Create an instance of CompleteRequestOpenai from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CompleteRequestOpenai.model_validate(obj)

        _obj = CompleteRequestOpenai.model_validate(
            {
                "reasoning": CompleteRequestOpenaiReasoning.from_dict(obj.get("reasoning"))
                if obj.get("reasoning") is not None
                else None,
            }
        )

        return _obj


class CompleteRequestOpenaiModel:
    def __init__(
        self,  # optional properties
        reasoning: Optional[CompleteRequestOpenaiReasoning] = None,
    ):
        """A model object representing the CompleteRequestOpenai resource.

        Constructs an object of type CompleteRequestOpenai with the provided properties.

        Parameters
        __________
        reasoning : CompleteRequestOpenaiReasoning, optional
        """
        self.reasoning = reasoning

    __properties = ["reasoning"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CompleteRequestOpenai(
            reasoning=self.reasoning._to_model() if self.reasoning is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> CompleteRequestOpenaiModel:
        return CompleteRequestOpenaiModel(
            reasoning=CompleteRequestOpenaiReasoningModel._from_model(model.reasoning) if model.reasoning else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CompleteRequestOpenai.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CompleteRequestOpenai object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CompleteRequestOpenaiModel:
        """Create an instance of CompleteRequestOpenai from a dict.

        This method constructs a CompleteRequestOpenai object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CompleteRequestOpenai
            A CompleteRequestOpenai object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CompleteRequestOpenai.from_dict(obj))


CompleteRequestOpenai._model_class = CompleteRequestOpenaiModel
