"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator


class ImageDetails(BaseModel):
    """A model object representing the ImageDetails resource.

    Constructs an object of type ImageDetails with the provided properties.

    Parameters
    __________
    type : str, optional
        Whether the image content is base64.
    content : str, optional
        base64 encoded image.
    content_type : str, optional
        Type of image.
    detail : str, optional
        Level of detail to process the image. Only applicable for OpenAI models
    """

    type: Optional[StrictStr] = None

    content: Optional[StrictStr] = None

    content_type: Optional[StrictStr] = None

    detail: Optional[StrictStr] = None

    __properties = ["type", "content", "content_type", "detail"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("base64"):
            raise ValueError("must validate the enum values ('base64')")
        return v

    @field_validator("content_type")
    def content_type_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("image/jpeg", "image/jpg", "image/png", "image/gif", "image/webp", "image/heic", "image/heif"):
            raise ValueError(
                "must validate the enum values ('image/jpeg','image/jpg','image/png','image/gif','image/webp','image/heic','image/heif')"
            )
        return v

    @field_validator("detail")
    def detail_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("auto", "low", "high"):
            raise ValueError("must validate the enum values ('auto','low','high')")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageDetails:
        """Create an instance of ImageDetails from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ImageDetails:
        """Create an instance of ImageDetails from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ImageDetails.model_validate(obj)

        _obj = ImageDetails.model_validate(
            {
                "type": obj.get("type"),
                "content": obj.get("content"),
                "content_type": obj.get("content_type"),
                "detail": obj.get("detail"),
            }
        )

        return _obj


class ImageDetailsModel:
    def __init__(
        self,  # optional properties
        type: Optional[str] = None,
        content: Optional[str] = None,
        content_type: Optional[str] = None,
        detail: Optional[str] = None,
    ):
        """A model object representing the ImageDetails resource.

        Constructs an object of type ImageDetails with the provided properties.

        Parameters
        __________
        type : str, optional
            Whether the image content is base64.
        content : str, optional
            base64 encoded image.
        content_type : str, optional
            Type of image.
        detail : str, optional
            Level of detail to process the image. Only applicable for OpenAI models
        """
        self.type = type
        self.content = content
        self.content_type = content_type
        self.detail = detail

    __properties = ["type", "content", "content_type", "detail"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ImageDetails(
            type=self.type,
            content=self.content,
            content_type=self.content_type,
            detail=self.detail,
        )

    @classmethod
    def _from_model(cls, model) -> ImageDetailsModel:
        return ImageDetailsModel(
            type=model.type,
            content=model.content,
            content_type=model.content_type,
            detail=model.detail,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ImageDetails.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ImageDetails object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ImageDetailsModel:
        """Create an instance of ImageDetails from a dict.

        This method constructs a ImageDetails object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ImageDetails
            A ImageDetails object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ImageDetails.from_dict(obj))


ImageDetails._model_class = ImageDetailsModel
