"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import BaseModel, ConfigDict, StrictStr


class OpenAIReasoning(BaseModel):
    """A model object representing the OpenAIReasoning resource.

    Constructs an object of type OpenAIReasoning with the provided properties.

    Parameters
    __________
    summary : str
        Reasoning summary tokens generated during the model response.
    encrypted_content : str
        The encrypted_content field is an opaque field and should not be interpreted or parsed.
        It should only be used for verifying that the reasoning blocks were generated by that specific model.
    """

    summary: StrictStr

    encrypted_content: StrictStr

    __properties = ["summary", "encrypted_content"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OpenAIReasoning:
        """Create an instance of OpenAIReasoning from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> OpenAIReasoning:
        """Create an instance of OpenAIReasoning from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OpenAIReasoning.model_validate(obj)

        _obj = OpenAIReasoning.model_validate(
            {
                "summary": obj.get("summary"),
                "encrypted_content": obj.get("encrypted_content"),
            }
        )

        return _obj


class OpenAIReasoningModel:
    def __init__(
        self,
        summary: str,
        encrypted_content: str,
        # optional properties
    ):
        """A model object representing the OpenAIReasoning resource.

                Constructs an object of type OpenAIReasoning with the provided properties.

                Parameters
                __________
                summary : str
                    Reasoning summary tokens generated during the model response.

                encrypted_content : str
                    The encrypted_content field is an opaque field and should not be interpreted or parsed.
        It should only be used for verifying that the reasoning blocks were generated by that specific model.
        """
        self.summary = summary
        self.encrypted_content = encrypted_content

    __properties = ["summary", "encrypted_content"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return OpenAIReasoning(
            summary=self.summary,
            encrypted_content=self.encrypted_content,
        )

    @classmethod
    def _from_model(cls, model) -> OpenAIReasoningModel:
        return OpenAIReasoningModel(
            summary=model.summary,
            encrypted_content=model.encrypted_content,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a OpenAIReasoning.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the OpenAIReasoning object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> OpenAIReasoningModel:
        """Create an instance of OpenAIReasoning from a dict.

        This method constructs a OpenAIReasoning object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        OpenAIReasoning
            A OpenAIReasoning object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(OpenAIReasoning.from_dict(obj))


OpenAIReasoning._model_class = OpenAIReasoningModel
