"""
Cortex Inference API.

OpenAPI 3.0 specification for the Cortex REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator

from snowflake.core.cortex.inference_service._generated.models.cache_control import CacheControl, CacheControlModel


class TextContent(BaseModel):
    """A model object representing the TextContent resource.

    Constructs an object of type TextContent with the provided properties.

    Parameters
    __________
    type : str
        Identifies this as text content.
    text : str
        The actual text content of the message.
    cache_control : CacheControl, optional
    """

    type: StrictStr

    text: StrictStr

    cache_control: Optional[CacheControl] = None

    __properties = ["type", "text", "cache_control"]

    @field_validator("type")
    def type_validate_enum(cls, v):
        if v not in ("text"):
            raise ValueError("must validate the enum values ('text')")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TextContent:
        """Create an instance of TextContent from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of cache_control
        if self.cache_control:
            _dict["cache_control"] = self.cache_control.to_dict()

        # set to None if cache_control (nullable) is None
        if self.cache_control is None:
            _dict["cache_control"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TextContent:
        """Create an instance of TextContent from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TextContent.model_validate(obj)

        _obj = TextContent.model_validate(
            {
                "type": obj.get("type"),
                "text": obj.get("text"),
                "cache_control": CacheControl.from_dict(obj.get("cache_control"))
                if obj.get("cache_control") is not None
                else None,
            }
        )

        return _obj


class TextContentModel:
    def __init__(
        self,
        type: str,
        text: str,
        # optional properties
        cache_control: Optional[CacheControl] = None,
    ):
        """A model object representing the TextContent resource.

        Constructs an object of type TextContent with the provided properties.

        Parameters
        __________
        type : str
            Identifies this as text content.
        text : str
            The actual text content of the message.
        cache_control : CacheControl, optional
        """
        self.type = type
        self.text = text
        self.cache_control = cache_control

    __properties = ["type", "text", "cache_control"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TextContent(
            type=self.type,
            text=self.text,
            cache_control=self.cache_control._to_model() if self.cache_control is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> TextContentModel:
        return TextContentModel(
            type=model.type,
            text=model.text,
            cache_control=CacheControlModel._from_model(model.cache_control) if model.cache_control else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TextContent.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TextContent object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TextContentModel:
        """Create an instance of TextContent from a dict.

        This method constructs a TextContent object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TextContent
            A TextContent object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TextContent.from_dict(obj))


TextContent._model_class = TextContentModel
