"""
Cortex Agent API.

OpenAPI 3.0 specification for the Cortex Agent API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.cortex.lite_agent_service._generated.models.sample_question import (
    SampleQuestion,
    SampleQuestionModel,
)


class AgentInstructions(BaseModel):
    """A model object representing the AgentInstructions resource.

    Constructs an object of type AgentInstructions with the provided properties.

    Parameters
    __________
    response : str, optional
        Instructions for response generation.
    orchestration : str, optional
        Instructions for orchestrating different tools.
    system : str, optional
        System instructions for the agent.
    sample_questions : list[SampleQuestion], optional
        Sample questions and optional answers for the agent.
    """

    response: Optional[StrictStr] = None

    orchestration: Optional[StrictStr] = None

    system: Optional[StrictStr] = None

    sample_questions: Optional[List[SampleQuestion]] = None

    __properties = ["response", "orchestration", "system", "sample_questions"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AgentInstructions:
        """Create an instance of AgentInstructions from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in sample_questions (list)
        _items = []
        if self.sample_questions:
            for _item in self.sample_questions:
                if _item:
                    _items.append(_item.to_dict())
            _dict["sample_questions"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AgentInstructions:
        """Create an instance of AgentInstructions from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AgentInstructions.model_validate(obj)

        _obj = AgentInstructions.model_validate(
            {
                "response": obj.get("response"),
                "orchestration": obj.get("orchestration"),
                "system": obj.get("system"),
                "sample_questions": [SampleQuestion.from_dict(_item) for _item in obj.get("sample_questions")]
                if obj.get("sample_questions") is not None
                else None,
            }
        )

        return _obj


class AgentInstructionsModel:
    def __init__(
        self,  # optional properties
        response: Optional[str] = None,
        orchestration: Optional[str] = None,
        system: Optional[str] = None,
        sample_questions: Optional[list[SampleQuestion]] = None,
    ):
        """A model object representing the AgentInstructions resource.

        Constructs an object of type AgentInstructions with the provided properties.

        Parameters
        __________
        response : str, optional
            Instructions for response generation.

        orchestration : str, optional
            Instructions for orchestrating different tools.

        system : str, optional
            System instructions for the agent.

        sample_questions : list[SampleQuestion], optional
            Sample questions and optional answers for the agent.
        """
        self.response = response
        self.orchestration = orchestration
        self.system = system
        self.sample_questions = sample_questions

    __properties = ["response", "orchestration", "system", "sample_questions"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AgentInstructions(
            response=self.response,
            orchestration=self.orchestration,
            system=self.system,
            sample_questions=[x._to_model() for x in self.sample_questions]
            if self.sample_questions is not None
            else None,
        )

    @classmethod
    def _from_model(cls, model) -> AgentInstructionsModel:
        return AgentInstructionsModel(
            response=model.response,
            orchestration=model.orchestration,
            system=model.system,
            sample_questions=[SampleQuestionModel._from_model(x) for x in model.sample_questions]
            if model.sample_questions
            else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AgentInstructions.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AgentInstructions object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AgentInstructionsModel:
        """Create an instance of AgentInstructions from a dict.

        This method constructs a AgentInstructions object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AgentInstructions
            A AgentInstructions object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AgentInstructions.from_dict(obj))


AgentInstructions._model_class = AgentInstructionsModel
