"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr

from snowflake.core.cortex.search_service._generated.models.scheduling_state import (
    SchedulingState,
)
from snowflake.core.cortex.search_service._generated.models.target_lag import TargetLag, TargetLagModel


class CreateCortexSearchServiceRequest(BaseModel):
    """A model object representing the CreateCortexSearchServiceRequest resource.

    Constructs an object of type CreateCortexSearchServiceRequest with the provided properties.

    Parameters
    __________
    name : str
        Specifies the name for the cortex search service, must be unique for the schema in which the cortex search service is created
    search_column : str
        Specifies the name of the search column for the cortex search service.
    target_lag : TargetLag

    warehouse : str
        Specifies the name of the warehouse that provides the compute resources for refreshing the cortex search service
    definition : str
        Specifies the definition (source query) used to create the cortex search service
    columns : list[str], optional
        Specifies all columns included in the cortex search service and that can be returned in search queries.
    attribute_columns : list[str], optional
        Specifies the attribute columns, which can be referenced in filters in search queries to the cortex search service.
    comment : str, optional
        Specifies a comment for the cortex search service
    created_on : datetime, optional
        Date and time when the cortex search service was created — **Read-only:** *any user-provided value will be ignored.*
    database_name : str, optional
        Database in which the cortex search service is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the cortex search service is stored — **Read-only:** *any user-provided value will be ignored.*
    source_data_num_rows : int, optional
        Number of rows in the materialized source data feeding into the cortex search service — **Read-only:** *any user-provided value will be ignored.*
    data_timestamp : datetime, optional
        Date and time as of which data existent in base tables is now serving — **Read-only:** *any user-provided value will be ignored.*
    indexing_state : SchedulingState, optional

    serving_state : SchedulingState, optional

    indexing_error : str, optional
        Error encountered during the latest indexing pipeline of the cortex search service, if any — **Read-only:** *any user-provided value will be ignored.*
    serving_data_bytes : int, optional
        Size of the serving index, in bytes — **Read-only:** *any user-provided value will be ignored.*
    """

    name: StrictStr

    search_column: StrictStr

    columns: Optional[List[StrictStr]] = None

    attribute_columns: Optional[List[StrictStr]] = None

    target_lag: TargetLag

    warehouse: StrictStr

    definition: StrictStr

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    database_name: Optional[StrictStr] = None

    schema_name: Optional[StrictStr] = None

    source_data_num_rows: Optional[StrictInt] = None

    data_timestamp: Optional[datetime] = None

    indexing_state: Optional[SchedulingState] = None

    serving_state: Optional[SchedulingState] = None

    indexing_error: Optional[StrictStr] = None

    serving_data_bytes: Optional[StrictInt] = None

    __properties = [
        "name",
        "search_column",
        "columns",
        "attribute_columns",
        "target_lag",
        "warehouse",
        "definition",
        "comment",
        "created_on",
        "database_name",
        "schema_name",
        "source_data_num_rows",
        "data_timestamp",
        "indexing_state",
        "serving_state",
        "indexing_error",
        "serving_data_bytes",
    ]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateCortexSearchServiceRequest:
        """Create an instance of CreateCortexSearchServiceRequest from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "source_data_num_rows",
                    "data_timestamp",
                    "indexing_error",
                    "serving_data_bytes",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of target_lag
        if self.target_lag:
            _dict["target_lag"] = self.target_lag.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCortexSearchServiceRequest:
        """Create an instance of CreateCortexSearchServiceRequest from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateCortexSearchServiceRequest.model_validate(obj)

        _obj = CreateCortexSearchServiceRequest.model_validate(
            {
                "name": obj.get("name"),
                "search_column": obj.get("search_column"),
                "columns": obj.get("columns"),
                "attribute_columns": obj.get("attribute_columns"),
                "target_lag": TargetLag.from_dict(obj.get("target_lag")) if obj.get("target_lag") is not None else None,
                "warehouse": obj.get("warehouse"),
                "definition": obj.get("definition"),
                "comment": obj.get("comment"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "source_data_num_rows": obj.get("source_data_num_rows"),
                "data_timestamp": obj.get("data_timestamp"),
                "indexing_state": obj.get("indexing_state"),
                "serving_state": obj.get("serving_state"),
                "indexing_error": obj.get("indexing_error"),
                "serving_data_bytes": obj.get("serving_data_bytes"),
            }
        )

        return _obj


class CreateCortexSearchServiceRequestModel:
    def __init__(
        self,
        name: str,
        search_column: str,
        target_lag: TargetLag,
        warehouse: str,
        definition: str,
        # optional properties
        columns: Optional[list[str]] = None,
        attribute_columns: Optional[list[str]] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        source_data_num_rows: Optional[int] = None,
        data_timestamp: Optional[datetime] = None,
        indexing_state: Optional[SchedulingState] = None,
        serving_state: Optional[SchedulingState] = None,
        indexing_error: Optional[str] = None,
        serving_data_bytes: Optional[int] = None,
    ):
        """A model object representing the CreateCortexSearchServiceRequest resource.

        Constructs an object of type CreateCortexSearchServiceRequest with the provided properties.

        Parameters
        __________
        name : str
            Specifies the name for the cortex search service, must be unique for the schema in which the cortex search service is created
        search_column : str
            Specifies the name of the search column for the cortex search service.
        target_lag : TargetLag

        warehouse : str
            Specifies the name of the warehouse that provides the compute resources for refreshing the cortex search service
        definition : str
            Specifies the definition (source query) used to create the cortex search service
        columns : list[str], optional
            Specifies all columns included in the cortex search service and that can be returned in search queries.
        attribute_columns : list[str], optional
            Specifies the attribute columns, which can be referenced in filters in search queries to the cortex search service.
        comment : str, optional
            Specifies a comment for the cortex search service
        created_on : datetime, optional
            Date and time when the cortex search service was created.
        database_name : str, optional
            Database in which the cortex search service is stored
        schema_name : str, optional
            Schema in which the cortex search service is stored
        source_data_num_rows : int, optional
            Number of rows in the materialized source data feeding into the cortex search service.
        data_timestamp : datetime, optional
            Date and time as of which data existent in base tables is now serving.
        indexing_state : SchedulingState, optional

        serving_state : SchedulingState, optional

        indexing_error : str, optional
            Error encountered during the latest indexing pipeline of the cortex search service, if any.
        serving_data_bytes : int, optional
            Size of the serving index, in bytes.
        """
        self.name = name
        self.search_column = search_column
        self.columns = columns
        self.attribute_columns = attribute_columns
        self.target_lag = target_lag
        self.warehouse = warehouse
        self.definition = definition
        self.comment = comment
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.source_data_num_rows = source_data_num_rows
        self.data_timestamp = data_timestamp
        self.indexing_state = indexing_state
        self.serving_state = serving_state
        self.indexing_error = indexing_error
        self.serving_data_bytes = serving_data_bytes

    __properties = [
        "name",
        "search_column",
        "columns",
        "attribute_columns",
        "target_lag",
        "warehouse",
        "definition",
        "comment",
        "created_on",
        "database_name",
        "schema_name",
        "source_data_num_rows",
        "data_timestamp",
        "indexing_state",
        "serving_state",
        "indexing_error",
        "serving_data_bytes",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CreateCortexSearchServiceRequest(
            name=self.name,
            search_column=self.search_column,
            columns=self.columns,
            attribute_columns=self.attribute_columns,
            target_lag=self.target_lag._to_model() if self.target_lag is not None else None,
            warehouse=self.warehouse,
            definition=self.definition,
            comment=self.comment,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            source_data_num_rows=self.source_data_num_rows,
            data_timestamp=self.data_timestamp,
            indexing_state=self.indexing_state,
            serving_state=self.serving_state,
            indexing_error=self.indexing_error,
            serving_data_bytes=self.serving_data_bytes,
        )

    @classmethod
    def _from_model(cls, model) -> CreateCortexSearchServiceRequestModel:
        return CreateCortexSearchServiceRequestModel(
            name=model.name,
            search_column=model.search_column,
            columns=model.columns,
            attribute_columns=model.attribute_columns,
            target_lag=TargetLagModel._from_model(model.target_lag) if model.target_lag else None,
            warehouse=model.warehouse,
            definition=model.definition,
            comment=model.comment,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            source_data_num_rows=model.source_data_num_rows,
            data_timestamp=model.data_timestamp,
            indexing_state=model.indexing_state,
            serving_state=model.serving_state,
            indexing_error=model.indexing_error,
            serving_data_bytes=model.serving_data_bytes,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CreateCortexSearchServiceRequest.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CreateCortexSearchServiceRequest object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCortexSearchServiceRequestModel:
        """Create an instance of CreateCortexSearchServiceRequest from a dict.

        This method constructs a CreateCortexSearchServiceRequest object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CreateCortexSearchServiceRequest
            A CreateCortexSearchServiceRequest object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CreateCortexSearchServiceRequest.from_dict(obj))


CreateCortexSearchServiceRequest._model_class = CreateCortexSearchServiceRequestModel
