"""
Cortex Search REST API.

OpenAPI 3.0 specification for the Cortex Search REST API  # noqa: E501

The version of the OpenAPI document: 0.1.0
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import ConfigDict

from snowflake.core.cortex.search_service._generated.models.target_lag import TargetLag


class DownstreamLag(TargetLag):
    """A model object representing the DownstreamLag resource.

    Constructs an object of type DownstreamLag with the provided properties.

    Parameters
    __________
    """

    __properties = ["type"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DownstreamLag:
        """Create an instance of DownstreamLag from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["type"] = TargetLag.get_child_model_discriminator_value("DownstreamLag")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DownstreamLag:
        """Create an instance of DownstreamLag from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DownstreamLag.model_validate(obj)

        _obj = DownstreamLag.model_validate({})

        return _obj


class DownstreamLagModel(TargetLag):
    def __init__(
        self,  # optional properties
    ):
        """A model object representing the DownstreamLag resource.

        Constructs an object of type DownstreamLag with the provided properties.

        Parameters
        __________
        """
        super().__init__()

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DownstreamLag()

    @classmethod
    def _from_model(cls, model) -> DownstreamLagModel:
        return DownstreamLagModel()

    def to_dict(self):
        """Create a dictionary of the properties from a DownstreamLag.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DownstreamLag object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DownstreamLagModel:
        """Create an instance of DownstreamLag from a dict.

        This method constructs a DownstreamLag object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DownstreamLag
            A DownstreamLag object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DownstreamLag.from_dict(obj))


DownstreamLag._model_class = DownstreamLagModel
