"""
Snowflake Database API.

The Snowflake Database API is a REST API that you can use to access, update, and perform certain actions on Database resource in Snowflake.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated


class DatabaseFromShare(BaseModel):
    """A model object representing the DatabaseFromShare resource.

    Constructs an object of type DatabaseFromShare with the provided properties.

    Parameters
    __________
    name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    """

    name: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = ["name"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DatabaseFromShare:
        """Create an instance of DatabaseFromShare from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseFromShare:
        """Create an instance of DatabaseFromShare from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DatabaseFromShare.model_validate(obj)

        _obj = DatabaseFromShare.model_validate(
            {
                "name": obj.get("name"),
            }
        )

        return _obj


class DatabaseFromShareModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
    ):
        """A model object representing the DatabaseFromShare resource.

        Constructs an object of type DatabaseFromShare with the provided properties.

        Parameters
        __________
        name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        """
        self.name = name

    __properties = ["name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DatabaseFromShare(
            name=self.name,
        )

    @classmethod
    def _from_model(cls, model) -> DatabaseFromShareModel:
        return DatabaseFromShareModel(
            name=model.name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a DatabaseFromShare.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DatabaseFromShare object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseFromShareModel:
        """Create an instance of DatabaseFromShare from a dict.

        This method constructs a DatabaseFromShare object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DatabaseFromShare
            A DatabaseFromShare object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DatabaseFromShare.from_dict(obj))


DatabaseFromShare._model_class = DatabaseFromShareModel
