"""
Snowflake Database Role API.

The Snowflake Database Role API is a REST API that you can use to access, update, and perform certain actions on Database Role resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated


class DatabaseRoleClone(BaseModel):
    """A model object representing the DatabaseRoleClone resource.

    Constructs an object of type DatabaseRoleClone with the provided properties.

    Parameters
    __________
    name : str
        Name of the database role
    """

    name: Annotated[str, Field(strict=True)]

    __properties = ["name"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DatabaseRoleClone:
        """Create an instance of DatabaseRoleClone from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseRoleClone:
        """Create an instance of DatabaseRoleClone from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DatabaseRoleClone.model_validate(obj)

        _obj = DatabaseRoleClone.model_validate(
            {
                "name": obj.get("name"),
            }
        )

        return _obj


class DatabaseRoleCloneModel:
    def __init__(
        self,
        name: str,
        # optional properties
    ):
        """A model object representing the DatabaseRoleClone resource.

        Constructs an object of type DatabaseRoleClone with the provided properties.

        Parameters
        __________
        name : str
            Name of the database role
        """
        self.name = name

    __properties = ["name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DatabaseRoleClone(
            name=self.name,
        )

    @classmethod
    def _from_model(cls, model) -> DatabaseRoleCloneModel:
        return DatabaseRoleCloneModel(
            name=model.name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a DatabaseRoleClone.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DatabaseRoleClone object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DatabaseRoleCloneModel:
        """Create an instance of DatabaseRoleClone from a dict.

        This method constructs a DatabaseRoleClone object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DatabaseRoleClone
            A DatabaseRoleClone object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DatabaseRoleClone.from_dict(obj))


DatabaseRoleClone._model_class = DatabaseRoleCloneModel
