"""
Snowflake Database Role API.

The Snowflake Database Role API is a REST API that you can use to access, update, and perform certain actions on Database Role resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr

from snowflake.core.database_role._generated.models.containing_scope import ContainingScope, ContainingScopeModel
from snowflake.core.database_role._generated.models.securable import Securable, SecurableModel


class Grant(BaseModel):
    """A model object representing the Grant resource.

    Constructs an object of type Grant with the provided properties.

    Parameters
    __________
    securable_type : str
        Type of the securable to be granted.
    securable : Securable, optional

    containing_scope : ContainingScope, optional

    grant_option : bool, optional
        If true, allows the recipient role to grant the privileges to other roles.
    privileges : list[str], optional
        List of privileges to be granted.
    created_on : datetime, optional
        Date and time when the grant was created — **Read-only:** *any user-provided value will be ignored.*
    granted_by : str, optional
        The role that granted this privilege to this grantee — **Read-only:** *any user-provided value will be ignored.*
    """

    securable: Optional[Securable] = None

    containing_scope: Optional[ContainingScope] = None

    securable_type: StrictStr

    grant_option: Optional[StrictBool] = None

    privileges: Optional[List[StrictStr]] = None

    created_on: Optional[datetime] = None

    granted_by: Optional[StrictStr] = None

    __properties = [
        "securable",
        "containing_scope",
        "securable_type",
        "grant_option",
        "privileges",
        "created_on",
        "granted_by",
    ]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Grant:
        """Create an instance of Grant from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "granted_by",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of securable
        if self.securable:
            _dict["securable"] = self.securable.to_dict()

        # override the default output from pydantic by calling `to_dict()` of containing_scope
        if self.containing_scope:
            _dict["containing_scope"] = self.containing_scope.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Grant:
        """Create an instance of Grant from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Grant.model_validate(obj)

        _obj = Grant.model_validate(
            {
                "securable": Securable.from_dict(obj.get("securable")) if obj.get("securable") is not None else None,
                "containing_scope": ContainingScope.from_dict(obj.get("containing_scope"))
                if obj.get("containing_scope") is not None
                else None,
                "securable_type": obj.get("securable_type"),
                "grant_option": obj.get("grant_option"),
                "privileges": obj.get("privileges"),
                "created_on": obj.get("created_on"),
                "granted_by": obj.get("granted_by"),
            }
        )

        return _obj


class GrantModel:
    def __init__(
        self,
        securable_type: str,
        # optional properties
        securable: Optional[Securable] = None,
        containing_scope: Optional[ContainingScope] = None,
        grant_option: Optional[bool] = None,
        privileges: Optional[list[str]] = None,
        created_on: Optional[datetime] = None,
        granted_by: Optional[str] = None,
    ):
        """A model object representing the Grant resource.

        Constructs an object of type Grant with the provided properties.

        Parameters
        __________
        securable_type : str
            Type of the securable to be granted.
        securable : Securable, optional

        containing_scope : ContainingScope, optional

        grant_option : bool, optional
            If true, allows the recipient role to grant the privileges to other roles.
        privileges : list[str], optional
            List of privileges to be granted.
        created_on : datetime, optional
            Date and time when the grant was created
        granted_by : str, optional
            The role that granted this privilege to this grantee
        """
        self.securable = securable
        self.containing_scope = containing_scope
        self.securable_type = securable_type
        self.grant_option = grant_option
        self.privileges = privileges
        self.created_on = created_on
        self.granted_by = granted_by

    __properties = [
        "securable",
        "containing_scope",
        "securable_type",
        "grant_option",
        "privileges",
        "created_on",
        "granted_by",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Grant(
            securable=self.securable._to_model() if self.securable is not None else None,
            containing_scope=self.containing_scope._to_model() if self.containing_scope is not None else None,
            securable_type=self.securable_type,
            grant_option=self.grant_option,
            privileges=self.privileges,
            created_on=self.created_on,
            granted_by=self.granted_by,
        )

    @classmethod
    def _from_model(cls, model) -> GrantModel:
        return GrantModel(
            securable=SecurableModel._from_model(model.securable) if model.securable else None,
            containing_scope=ContainingScopeModel._from_model(model.containing_scope)
            if model.containing_scope
            else None,
            securable_type=model.securable_type,
            grant_option=model.grant_option,
            privileges=model.privileges,
            created_on=model.created_on,
            granted_by=model.granted_by,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Grant.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Grant object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GrantModel:
        """Create an instance of Grant from a dict.

        This method constructs a Grant object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Grant
            A Grant object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Grant.from_dict(obj))


Grant._model_class = GrantModel
