"""
Snowflake Dynamic Table API.

The Snowflake Dynamic Table API is a REST API that you can use to access, update, and perform certain actions on Dynamic Tables resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import warnings

from typing import TYPE_CHECKING, Iterator, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.dynamic_table._generated.models.dynamic_table import DynamicTable
from snowflake.core.dynamic_table._generated.models.dynamic_table_clone import DynamicTableClone

from .dynamic_table_api import DynamicTableApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class DynamicTableCollectionBase(SchemaObjectCollectionParent["DynamicTableResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = DynamicTableApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(
        self, dynamic_table: DynamicTable, mode: Optional[Union[CreateMode, str]] = None
    ) -> "DynamicTableResource":  # noqa: F821
        """Create a dynamic table.

        Parameters
        __________
        dynamic_table: DynamicTable
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_dynamic_table(
            self.database.name,
            self.schema.name,
            dynamic_table=dynamic_table,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(dynamic_table), self)
        return self._ref_class(dynamic_table.name, self)

    @api_telemetry
    def create_async(
        self, dynamic_table: DynamicTable, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["DynamicTableResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_dynamic_table(
            self.database.name,
            self.schema.name,
            dynamic_table=dynamic_table,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(future, lambda _: self._ref_class(get_function_name_with_args(dynamic_table), self))
        return PollingOperation(
            future,
            lambda _: self._ref_class(dynamic_table if isinstance(dynamic_table, str) else dynamic_table.name, self),
        )

    @api_telemetry
    def iter(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        from_name: Optional[str] = None,
        deep: Optional[bool] = None,
        show_limit: Optional[int] = None,
    ) -> Iterator[DynamicTable]:
        """List dynamic tables.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        starts_with: str
             Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        limit: int
             Parameter to limit the maximum number of rows returned by a command.
        from_name: str
             Parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        deep: bool
             Optionally includes dependency information of the dynamic table.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        resources = self._api.list_dynamic_tables(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            from_name=from_name,
            deep=deep,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        from_name: Optional[str] = None,
        deep: Optional[bool] = None,
        show_limit: Optional[int] = None,
    ) -> PollingOperation[Iterator[DynamicTable]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        future = self._api.list_dynamic_tables(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            from_name=from_name,
            deep=deep,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class DynamicTableResourceBase(SchemaObjectReferenceMixin["DynamicTableCollection"]):
    _collection_class: DynamicTableCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: DynamicTableCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def clone(
        self,
        dynamic_table_clone: DynamicTableClone,
        create_mode: Optional[Union[CreateMode, str]] = None,
        copy_grants: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> None:
        """Clone dynamic table.

        Parameters
        __________
        dynamic_table_clone: DynamicTableClone
             (required)
        create_mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        copy_grants: bool
             Parameter to enable copy grants when creating the object.
        target_database: str
             Database of the newly created dynamic table. Defaults to the source table's database.
        target_schema: str
             Schema of the newly created dynamic table. Defaults to the source table's schema.
        """
        self.collection._api.clone_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            dynamic_table_clone=dynamic_table_clone,
            create_mode=create_mode,
            copy_grants=copy_grants,
            target_database=target_database,
            target_schema=target_schema,
            async_req=False,
        )

    @api_telemetry
    def clone_async(
        self,
        dynamic_table_clone: DynamicTableClone,
        create_mode: Optional[Union[CreateMode, str]] = None,
        copy_grants: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`clone`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.clone_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            dynamic_table_clone=dynamic_table_clone,
            create_mode=create_mode,
            copy_grants=copy_grants,
            target_database=target_database,
            target_schema=target_schema,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def fetch(
        self,
    ) -> DynamicTable:
        """Fetch a dynamic table.

        Parameters
        __________
        """
        return self.collection._api.fetch_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[DynamicTable]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def refresh(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Refresh the dynamic table.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.refresh_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def refresh_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`refresh`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.refresh_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def resume(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Resume refreshes on the dynamic table.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.resume_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def resume_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`resume`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.resume_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def resume_recluster(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Resume recluster of a dynamic table.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.resume_recluster_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def resume_recluster_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`resume_recluster`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.resume_recluster_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def suspend(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Suspend refreshes on the dynamic table.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.suspend_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def suspend_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`suspend`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.suspend_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def suspend_recluster(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Suspend recluster of a dynamic table.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.suspend_recluster_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def suspend_recluster_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`suspend_recluster`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.suspend_recluster_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def swap_with(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> None:
        """Swap with another dynamic table.

        Parameters
        __________
        target_name: str
             The name of the target dynamic table to be swapped with. (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        target_database: str
             Database of the target dynamic table. Defaults to the source table's database.
        target_schema: str
             Schema of the target dynamic table. Defaults to the source table's schema.
        """
        self.collection._api.swap_with_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=False,
        )

    @api_telemetry
    def swap_with_async(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`swap_with`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.swap_with_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def undrop(
        self,
    ) -> None:
        """Undrop a dynamic table.

        Parameters
        __________
        """
        self.collection._api.undrop_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def undrop_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`undrop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.undrop_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a dynamic table.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_dynamic_table(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
