"""
Snowflake External Volume API.

The Snowflake External Volume API is a REST API that you can use to access, update, and perform certain actions on External Volume resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.external_volume._generated.models.storage_location import StorageLocation, StorageLocationModel


class ExternalVolume(BaseModel):
    """A model object representing the ExternalVolume resource.

    Constructs an object of type ExternalVolume with the provided properties.

    Parameters
    __________
    name : str
        String that specifies the identifier (the name) for the external volume; must be unique in your account.
    storage_locations : list[StorageLocation]
        Set of named cloud storage locations in different regions and, optionally, cloud platforms.
    allow_writes : bool, optional
        Specifies whether write operations are allowed for the external volume; must be set to TRUE for Iceberg tables that use Snowflake as the catalog.
    comment : str, optional
        String (literal) that specifies a comment for the external volume.
    created_on : datetime, optional
        Date and time when the external volume was created — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the external volume — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the external volume — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Annotated[str, Field(strict=True)]

    storage_locations: List[StorageLocation]

    allow_writes: Optional[StrictBool] = None

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = ["name", "storage_locations", "allow_writes", "comment", "created_on", "owner", "owner_role_type"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner_role_type")
    def owner_role_type_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalVolume:
        """Create an instance of ExternalVolume from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "owner",
                    "owner_role_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of each item in storage_locations (list)
        _items = []
        if self.storage_locations:
            for _item in self.storage_locations:
                if _item:
                    _items.append(_item.to_dict())
            _dict["storage_locations"] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalVolume:
        """Create an instance of ExternalVolume from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalVolume.model_validate(obj)

        _obj = ExternalVolume.model_validate(
            {
                "name": obj.get("name"),
                "storage_locations": [StorageLocation.from_dict(_item) for _item in obj.get("storage_locations")]
                if obj.get("storage_locations") is not None
                else None,
                "allow_writes": obj.get("allow_writes"),
                "comment": obj.get("comment"),
                "created_on": obj.get("created_on"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
            }
        )

        return _obj


class ExternalVolumeModel:
    def __init__(
        self,
        name: str,
        storage_locations: list[StorageLocation],
        # optional properties
        allow_writes: Optional[bool] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the ExternalVolume resource.

        Constructs an object of type ExternalVolume with the provided properties.

        Parameters
        __________
        name : str
            String that specifies the identifier (the name) for the external volume; must be unique in your account.
        storage_locations : list[StorageLocation]
            Set of named cloud storage locations in different regions and, optionally, cloud platforms.
        allow_writes : bool, optional
            Specifies whether write operations are allowed for the external volume; must be set to TRUE for Iceberg tables that use Snowflake as the catalog.
        comment : str, optional
            String (literal) that specifies a comment for the external volume.
        created_on : datetime, optional
            Date and time when the external volume was created.
        owner : str, optional
            Role that owns the external volume
        owner_role_type : str, optional
            The type of role that owns the external volume
        """
        self.name = name
        self.storage_locations = storage_locations
        self.allow_writes = allow_writes
        self.comment = comment
        self.created_on = created_on
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = ["name", "storage_locations", "allow_writes", "comment", "created_on", "owner", "owner_role_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ExternalVolume(
            name=self.name,
            storage_locations=[x._to_model() for x in self.storage_locations]
            if self.storage_locations is not None
            else None,
            allow_writes=self.allow_writes,
            comment=self.comment,
            created_on=self.created_on,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> ExternalVolumeModel:
        return ExternalVolumeModel(
            name=model.name,
            storage_locations=[StorageLocationModel._from_model(x) for x in model.storage_locations]
            if model.storage_locations
            else None,
            allow_writes=model.allow_writes,
            comment=model.comment,
            created_on=model.created_on,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ExternalVolume.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ExternalVolume object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalVolumeModel:
        """Create an instance of ExternalVolume from a dict.

        This method constructs a ExternalVolume object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ExternalVolume
            A ExternalVolume object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ExternalVolume.from_dict(obj))


ExternalVolume._model_class = ExternalVolumeModel
