"""
Snowflake External Volume API.

The Snowflake External Volume API is a REST API that you can use to access, update, and perform certain actions on External Volume resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.external_volume._generated.models.encryption import Encryption, EncryptionModel
from snowflake.core.external_volume._generated.models.storage_location import StorageLocation


class StorageLocationS3(StorageLocation):
    """A model object representing the StorageLocationS3 resource.

    Constructs an object of type StorageLocationS3 with the provided properties.

    Parameters
    __________

    name : str

    storage_aws_role_arn : str
        Specifies the case-sensitive Amazon Resource Name (ARN) of the AWS identity and access management (IAM) role that grants privileges on the S3 bucket containing your data files.
    storage_base_url : str
        Specifies the base URL for your cloud storage location.
    storage_aws_external_id : str, optional
        Optionally specifies an external ID that Snowflake uses to establish a trust relationship with AWS.
    encryption : Encryption, optional
    """

    storage_aws_role_arn: StrictStr

    storage_base_url: StrictStr

    storage_aws_external_id: Optional[StrictStr] = None

    encryption: Optional[Encryption] = None

    __properties = ["name", "storage_provider"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StorageLocationS3:
        """Create an instance of StorageLocationS3 from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of encryption
        if self.encryption:
            _dict["encryption"] = self.encryption.to_dict()

        _dict["storage_provider"] = StorageLocation.get_child_model_discriminator_value("StorageLocationS3")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StorageLocationS3:
        """Create an instance of StorageLocationS3 from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StorageLocationS3.model_validate(obj)

        _obj = StorageLocationS3.model_validate(
            {
                "name": obj.get("name"),
                "storage_aws_role_arn": obj.get("storage_aws_role_arn"),
                "storage_base_url": obj.get("storage_base_url"),
                "storage_aws_external_id": obj.get("storage_aws_external_id"),
                "encryption": Encryption.from_dict(obj.get("encryption"))
                if obj.get("encryption") is not None
                else None,
            }
        )

        return _obj


class StorageLocationS3Model(StorageLocation):
    def __init__(
        self,
        name: str,
        storage_aws_role_arn: str,
        storage_base_url: str,
        # optional properties
        storage_aws_external_id: Optional[str] = None,
        encryption: Optional[Encryption] = None,
    ):
        """A model object representing the StorageLocationS3 resource.

        Constructs an object of type StorageLocationS3 with the provided properties.

        Parameters
        __________

        name : str

        storage_aws_role_arn : str
            Specifies the case-sensitive Amazon Resource Name (ARN) of the AWS identity and access management (IAM) role that grants privileges on the S3 bucket containing your data files.
        storage_base_url : str
            Specifies the base URL for your cloud storage location.
        storage_aws_external_id : str, optional
            Optionally specifies an external ID that Snowflake uses to establish a trust relationship with AWS.
        encryption : Encryption, optional
        """
        super().__init__(
            name=name,
        )
        self.storage_aws_role_arn = storage_aws_role_arn
        self.storage_base_url = storage_base_url
        self.storage_aws_external_id = storage_aws_external_id
        self.encryption = encryption

    __properties = ["name", "storage_provider"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StorageLocationS3(
            name=self.name,
            storage_aws_role_arn=self.storage_aws_role_arn,
            storage_base_url=self.storage_base_url,
            storage_aws_external_id=self.storage_aws_external_id,
            encryption=self.encryption._to_model() if self.encryption is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> StorageLocationS3Model:
        return StorageLocationS3Model(
            name=model.name,
            storage_aws_role_arn=model.storage_aws_role_arn,
            storage_base_url=model.storage_base_url,
            storage_aws_external_id=model.storage_aws_external_id,
            encryption=EncryptionModel._from_model(model.encryption) if model.encryption else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StorageLocationS3.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StorageLocationS3 object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StorageLocationS3Model:
        """Create an instance of StorageLocationS3 from a dict.

        This method constructs a StorageLocationS3 object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StorageLocationS3
            A StorageLocationS3 object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StorageLocationS3.from_dict(obj))


StorageLocationS3._model_class = StorageLocationS3Model
