"""
Snowflake Function API.

The Snowflake Function API is a REST API that allows caller to create, execute and drop functions in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class FunctionArgument(BaseModel):
    """A model object representing the FunctionArgument resource.

    Constructs an object of type FunctionArgument with the provided properties.

    Parameters
    __________
    name : str, optional
        Argument's name
    datatype : str,  default 'TEXT'
        Argument's type
    value : object, optional
        Argument's value
    """

    name: Optional[StrictStr] = None

    datatype: Optional[StrictStr] = "TEXT"

    value: Optional[Any] = None

    __properties = ["name", "datatype", "value"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FunctionArgument:
        """Create an instance of FunctionArgument from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # set to None if value (nullable) is None
        if self.value is None:
            _dict["value"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> FunctionArgument:
        """Create an instance of FunctionArgument from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return FunctionArgument.model_validate(obj)

        _obj = FunctionArgument.model_validate(
            {
                "name": obj.get("name"),
                "datatype": obj.get("datatype") if obj.get("datatype") is not None else "TEXT",
                "value": obj.get("value"),
            }
        )

        return _obj


class FunctionArgumentModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        datatype: Optional[str] = "TEXT",
        value: Optional[object] = None,
    ):
        """A model object representing the FunctionArgument resource.

        Constructs an object of type FunctionArgument with the provided properties.

        Parameters
        __________
        name : str, optional
            Argument's name
        datatype : str,  default 'TEXT'
            Argument's type
        value : object, optional
            Argument's value
        """
        self.name = name
        self.datatype = datatype
        self.value = value

    __properties = ["name", "datatype", "value"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return FunctionArgument(
            name=self.name,
            datatype=self.datatype,
            value=self.value,
        )

    @classmethod
    def _from_model(cls, model) -> FunctionArgumentModel:
        return FunctionArgumentModel(
            name=model.name,
            datatype=model.datatype,
            value=model.value,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a FunctionArgument.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the FunctionArgument object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> FunctionArgumentModel:
        """Create an instance of FunctionArgument from a dict.

        This method constructs a FunctionArgument object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        FunctionArgument
            A FunctionArgument object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(FunctionArgument.from_dict(obj))


FunctionArgument._model_class = FunctionArgumentModel
