"""
Snowflake Iceberg Table API.

The Snowflake Iceberg Table API is a REST API that you can use to access, update, and perform certain actions on Iceberg Table resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated


class IcebergTableColumn(BaseModel):
    """A model object representing the IcebergTableColumn resource.

    Constructs an object of type IcebergTableColumn with the provided properties.

    Parameters
    __________
    name : str
        Column name
    datatype : str
        The data type for the column
    comment : str, optional
        Specifies a comment for the column
    nullable : bool, optional
        Argument null return acceptance criteria
    default_value : str, optional
        Default value for the column
    """

    name: Annotated[str, Field(strict=True)]

    datatype: StrictStr

    comment: Optional[StrictStr] = None

    nullable: Optional[StrictBool] = None

    default_value: Optional[StrictStr] = None

    __properties = ["name", "datatype", "comment", "nullable", "default_value"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IcebergTableColumn:
        """Create an instance of IcebergTableColumn from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableColumn:
        """Create an instance of IcebergTableColumn from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return IcebergTableColumn.model_validate(obj)

        _obj = IcebergTableColumn.model_validate(
            {
                "name": obj.get("name"),
                "datatype": obj.get("datatype"),
                "comment": obj.get("comment"),
                "nullable": obj.get("nullable"),
                "default_value": obj.get("default_value"),
            }
        )

        return _obj


class IcebergTableColumnModel:
    def __init__(
        self,
        name: str,
        datatype: str,
        # optional properties
        comment: Optional[str] = None,
        nullable: Optional[bool] = None,
        default_value: Optional[str] = None,
    ):
        """A model object representing the IcebergTableColumn resource.

        Constructs an object of type IcebergTableColumn with the provided properties.

        Parameters
        __________
        name : str
            Column name
        datatype : str
            The data type for the column
        comment : str, optional
            Specifies a comment for the column
        nullable : bool, optional
            Argument null return acceptance criteria
        default_value : str, optional
            Default value for the column
        """
        self.name = name
        self.datatype = datatype
        self.comment = comment
        self.nullable = nullable
        self.default_value = default_value

    __properties = ["name", "datatype", "comment", "nullable", "default_value"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return IcebergTableColumn(
            name=self.name,
            datatype=self.datatype,
            comment=self.comment,
            nullable=self.nullable,
            default_value=self.default_value,
        )

    @classmethod
    def _from_model(cls, model) -> IcebergTableColumnModel:
        return IcebergTableColumnModel(
            name=model.name,
            datatype=model.datatype,
            comment=model.comment,
            nullable=model.nullable,
            default_value=model.default_value,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a IcebergTableColumn.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the IcebergTableColumn object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> IcebergTableColumnModel:
        """Create an instance of IcebergTableColumn from a dict.

        This method constructs a IcebergTableColumn object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        IcebergTableColumn
            A IcebergTableColumn object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(IcebergTableColumn.from_dict(obj))


IcebergTableColumn._model_class = IcebergTableColumnModel
