"""
Snowflake Network Policy API.

The Snowflake Network Policy API is a REST API that you can use to access, update, and perform certain actions on Network Policy resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated


class NetworkPolicy(BaseModel):
    """A model object representing the NetworkPolicy resource.

    Constructs an object of type NetworkPolicy with the provided properties.

    Parameters
    __________
    name : str
        Name of the network policy
    allowed_network_rule_list : list[str], optional
        List of names of allowed network rules in a network policy
    blocked_network_rule_list : list[str], optional
        List of names of blocked network rules in a network policy
    allowed_ip_list : list[str], optional
        List of allowed IPs in a network policy
    blocked_ip_list : list[str], optional
        List of blocked IPs in a network policy
    comment : str, optional
        user comment associated to an object in the dictionary
    created_on : datetime, optional
        Date and time when the network policy was created — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the network policy — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the network policy — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Annotated[str, Field(strict=True)]

    allowed_network_rule_list: Optional[List[StrictStr]] = None

    blocked_network_rule_list: Optional[List[StrictStr]] = None

    allowed_ip_list: Optional[List[StrictStr]] = None

    blocked_ip_list: Optional[List[StrictStr]] = None

    comment: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    __properties = [
        "name",
        "allowed_network_rule_list",
        "blocked_network_rule_list",
        "allowed_ip_list",
        "blocked_ip_list",
        "comment",
        "created_on",
        "owner",
        "owner_role_type",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner_role_type")
    def owner_role_type_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NetworkPolicy:
        """Create an instance of NetworkPolicy from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "owner",
                    "owner_role_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NetworkPolicy:
        """Create an instance of NetworkPolicy from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NetworkPolicy.model_validate(obj)

        _obj = NetworkPolicy.model_validate(
            {
                "name": obj.get("name"),
                "allowed_network_rule_list": obj.get("allowed_network_rule_list"),
                "blocked_network_rule_list": obj.get("blocked_network_rule_list"),
                "allowed_ip_list": obj.get("allowed_ip_list"),
                "blocked_ip_list": obj.get("blocked_ip_list"),
                "comment": obj.get("comment"),
                "created_on": obj.get("created_on"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
            }
        )

        return _obj


class NetworkPolicyModel:
    def __init__(
        self,
        name: str,
        # optional properties
        allowed_network_rule_list: Optional[list[str]] = None,
        blocked_network_rule_list: Optional[list[str]] = None,
        allowed_ip_list: Optional[list[str]] = None,
        blocked_ip_list: Optional[list[str]] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the NetworkPolicy resource.

        Constructs an object of type NetworkPolicy with the provided properties.

        Parameters
        __________
        name : str
            Name of the network policy
        allowed_network_rule_list : list[str], optional
            List of names of allowed network rules in a network policy
        blocked_network_rule_list : list[str], optional
            List of names of blocked network rules in a network policy
        allowed_ip_list : list[str], optional
            List of allowed IPs in a network policy
        blocked_ip_list : list[str], optional
            List of blocked IPs in a network policy
        comment : str, optional
            user comment associated to an object in the dictionary
        created_on : datetime, optional
            Date and time when the network policy was created.
        owner : str, optional
            Role that owns the network policy
        owner_role_type : str, optional
            The type of role that owns the network policy
        """
        self.name = name
        self.allowed_network_rule_list = allowed_network_rule_list
        self.blocked_network_rule_list = blocked_network_rule_list
        self.allowed_ip_list = allowed_ip_list
        self.blocked_ip_list = blocked_ip_list
        self.comment = comment
        self.created_on = created_on
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = [
        "name",
        "allowed_network_rule_list",
        "blocked_network_rule_list",
        "allowed_ip_list",
        "blocked_ip_list",
        "comment",
        "created_on",
        "owner",
        "owner_role_type",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NetworkPolicy(
            name=self.name,
            allowed_network_rule_list=self.allowed_network_rule_list,
            blocked_network_rule_list=self.blocked_network_rule_list,
            allowed_ip_list=self.allowed_ip_list,
            blocked_ip_list=self.blocked_ip_list,
            comment=self.comment,
            created_on=self.created_on,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> NetworkPolicyModel:
        return NetworkPolicyModel(
            name=model.name,
            allowed_network_rule_list=model.allowed_network_rule_list,
            blocked_network_rule_list=model.blocked_network_rule_list,
            allowed_ip_list=model.allowed_ip_list,
            blocked_ip_list=model.blocked_ip_list,
            comment=model.comment,
            created_on=model.created_on,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a NetworkPolicy.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NetworkPolicy object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NetworkPolicyModel:
        """Create an instance of NetworkPolicy from a dict.

        This method constructs a NetworkPolicy object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NetworkPolicy
            A NetworkPolicy object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NetworkPolicy.from_dict(obj))


NetworkPolicy._model_class = NetworkPolicyModel
