"""
Snowflake Notification Integration API.

The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from typing import TYPE_CHECKING, Iterator, Optional, TypeVar, Union

from snowflake.core._common import AccountObjectCollectionParent, CreateMode, ObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.notification_integration._generated.models.notification_integration import NotificationIntegration

from .notification_integration_api import NotificationIntegrationApi


if TYPE_CHECKING:
    from snowflake.core import Root


T = TypeVar("T")


class NotificationIntegrationCollectionBase(AccountObjectCollectionParent["NotificationIntegrationResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, root: "Root", resource_class: type[T]) -> None:
        super().__init__(root, resource_class)
        self._api = NotificationIntegrationApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(
        self, notification_integration: NotificationIntegration, mode: Optional[Union[CreateMode, str]] = None
    ) -> "NotificationIntegrationResource":  # noqa: F821
        """Create a notification integration.

        Parameters
        __________
        notification_integration: NotificationIntegration
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_notification_integration(
            notification_integration=notification_integration,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(notification_integration), self)
        return self._ref_class(notification_integration.name, self)

    @api_telemetry
    def create_async(
        self, notification_integration: NotificationIntegration, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["NotificationIntegrationResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_notification_integration(
            notification_integration=notification_integration,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(
                future, lambda _: self._ref_class(get_function_name_with_args(notification_integration), self)
            )
        return PollingOperation(
            future,
            lambda _: self._ref_class(
                notification_integration
                if isinstance(notification_integration, str)
                else notification_integration.name,
                self,
            ),
        )

    @api_telemetry
    def iter(self, *, like: Optional[str] = None) -> Iterator[NotificationIntegration]:
        """List notification integrations.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        """
        resources = self._api.list_notification_integrations(
            like=like,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(self, *, like: Optional[str] = None) -> PollingOperation[Iterator[NotificationIntegration]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self._api.list_notification_integrations(
            like=like,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class NotificationIntegrationResourceBase(ObjectReferenceMixin["NotificationIntegrationCollection"]):
    _collection_class: NotificationIntegrationCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: NotificationIntegrationCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def fetch(
        self,
    ) -> NotificationIntegration:
        """Fetch a notification integration.

        Parameters
        __________
        """
        return self.collection._api.fetch_notification_integration(
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[NotificationIntegration]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_notification_integration(
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a notification integration.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_notification_integration(
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_notification_integration(
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
