"""
Snowflake Notification Integration API.

The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.notification_integration._generated.models.notification_hook import (
    NotificationHook,
)


class NotificationQueueGcpPubsubInbound(NotificationHook):
    """A model object representing the NotificationQueueGcpPubsubInbound resource.

    Constructs an object of type NotificationQueueGcpPubsubInbound with the provided properties.

    Parameters
    __________
    gcp_pubsub_subscription_name : str, optional
        Pub/Sub topic subscription ID used to allow Snowflake access to event messages.
    gcp_pubsub_service_account : str, optional
        Google Cloud Platform (GCP) service account created for your account — **Read-only:** *any user-provided value will be ignored.*
    """

    gcp_pubsub_subscription_name: Optional[StrictStr] = None

    gcp_pubsub_service_account: Optional[StrictStr] = None

    __properties = ["type"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationQueueGcpPubsubInbound:
        """Create an instance of NotificationQueueGcpPubsubInbound from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "gcp_pubsub_service_account",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["type"] = NotificationHook.get_child_model_discriminator_value("NotificationQueueGcpPubsubInbound")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationQueueGcpPubsubInbound:
        """Create an instance of NotificationQueueGcpPubsubInbound from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NotificationQueueGcpPubsubInbound.model_validate(obj)

        _obj = NotificationQueueGcpPubsubInbound.model_validate(
            {
                "gcp_pubsub_subscription_name": obj.get("gcp_pubsub_subscription_name"),
                "gcp_pubsub_service_account": obj.get("gcp_pubsub_service_account"),
            }
        )

        return _obj


class NotificationQueueGcpPubsubInboundModel(NotificationHook):
    def __init__(
        self,  # optional properties
        gcp_pubsub_subscription_name: Optional[str] = None,
        gcp_pubsub_service_account: Optional[str] = None,
    ):
        """A model object representing the NotificationQueueGcpPubsubInbound resource.

        Constructs an object of type NotificationQueueGcpPubsubInbound with the provided properties.

        Parameters
        __________
        gcp_pubsub_subscription_name : str, optional
            Pub/Sub topic subscription ID used to allow Snowflake access to event messages.
        gcp_pubsub_service_account : str, optional
            Google Cloud Platform (GCP) service account created for your account.
        """
        super().__init__()
        self.gcp_pubsub_subscription_name = gcp_pubsub_subscription_name
        self.gcp_pubsub_service_account = gcp_pubsub_service_account

    __properties = ["type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return NotificationQueueGcpPubsubInbound(
            gcp_pubsub_subscription_name=self.gcp_pubsub_subscription_name,
            gcp_pubsub_service_account=self.gcp_pubsub_service_account,
        )

    @classmethod
    def _from_model(cls, model) -> NotificationQueueGcpPubsubInboundModel:
        return NotificationQueueGcpPubsubInboundModel(
            gcp_pubsub_subscription_name=model.gcp_pubsub_subscription_name,
            gcp_pubsub_service_account=model.gcp_pubsub_service_account,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a NotificationQueueGcpPubsubInbound.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the NotificationQueueGcpPubsubInbound object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationQueueGcpPubsubInboundModel:
        """Create an instance of NotificationQueueGcpPubsubInbound from a dict.

        This method constructs a NotificationQueueGcpPubsubInbound object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        NotificationQueueGcpPubsubInbound
            A NotificationQueueGcpPubsubInbound object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(NotificationQueueGcpPubsubInbound.from_dict(obj))


NotificationQueueGcpPubsubInbound._model_class = NotificationQueueGcpPubsubInboundModel
