"""
Snowflake Password Policy API.

The Snowflake Password Policy API is a REST API that you can use to access, update, and perform certain actions on Password Policy resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import warnings

from typing import TYPE_CHECKING, Any, Iterator, Optional, TypeVar, Union

from snowflake.core._common import CreateMode, SchemaObjectCollectionParent, SchemaObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.password_policy._generated.models.password_policy import PasswordPolicy

from .password_policy_api import PasswordPolicyApi


if TYPE_CHECKING:
    from snowflake.core.schema import SchemaResource


T = TypeVar("T")


class PasswordPolicyCollectionBase(SchemaObjectCollectionParent["PasswordPolicyResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, schema: "SchemaResource", resource_class: type[T]) -> None:
        super().__init__(schema, resource_class)
        self._api = PasswordPolicyApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(
        self, password_policy: PasswordPolicy, mode: Optional[Union[CreateMode, str]] = None
    ) -> "PasswordPolicyResource":  # noqa: F821
        """Create a password policy.

        Parameters
        __________
        password_policy: PasswordPolicy
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_password_policy(
            self.database.name,
            self.schema.name,
            password_policy=password_policy,
            create_mode=mode,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(password_policy), self)
        return self._ref_class(password_policy.name, self)

    @api_telemetry
    def create_async(
        self, password_policy: PasswordPolicy, mode: Optional[Union[CreateMode, str]] = None
    ) -> PollingOperation["PasswordPolicyResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_password_policy(
            self.database.name,
            self.schema.name,
            password_policy=password_policy,
            create_mode=mode,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(
                future, lambda _: self._ref_class(get_function_name_with_args(password_policy), self)
            )
        return PollingOperation(
            future,
            lambda _: self._ref_class(
                password_policy if isinstance(password_policy, str) else password_policy.name, self
            ),
        )

    @api_telemetry
    def iter(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        show_limit: Optional[int] = None,
    ) -> Iterator[PasswordPolicy]:
        """List password policies.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        starts_with: str
             Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        limit: int
             Parameter to limit the maximum number of rows returned by a command.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        resources = self._api.list_password_policies(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        show_limit: Optional[int] = None,
    ) -> PollingOperation[Iterator[PasswordPolicy]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        future = self._api.list_password_policies(
            self.database.name,
            self.schema.name,
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class PasswordPolicyResourceBase(SchemaObjectReferenceMixin["PasswordPolicyCollection"]):
    _collection_class: PasswordPolicyCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: PasswordPolicyCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def fetch(
        self,
    ) -> PasswordPolicy:
        """Fetch a password policy.

        Parameters
        __________
        """
        return self.collection._api.fetch_password_policy(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[PasswordPolicy]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_password_policy(
            self.database.name,
            self.schema.name,
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def rename(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> None:
        """Rename a password policy with a new identifier.

        Parameters
        __________
        target_name: str
             Name of the target resource. (required)
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        target_database: str
             Database of the target resource. Defaults to the source's database
        target_schema: str
             Schema of the target resource. Defaults to the source's schema
        """
        self.collection._api.rename_password_policy(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=False,
        )

        self._rename_finalizer(target_name, target_schema, target_database)

    @api_telemetry
    def rename_async(
        self,
        target_name: str,
        if_exists: Optional[bool] = None,
        target_database: Optional[str] = None,
        target_schema: Optional[str] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`rename`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.rename_password_policy(
            self.database.name,
            self.schema.name,
            self._identifier,
            target_name=target_name,
            if_exists=if_exists,
            target_database=target_database,
            target_schema=target_schema,
            async_req=True,
        )

        def finalize(_: Any) -> None:
            self._rename_finalizer(
                target_name=target_name, target_schema=target_schema, target_database=target_database
            )

        return PollingOperation(future, finalize)

    def _rename_finalizer(self, target_name: str, target_schema: Optional[str], target_database: Optional[str]) -> None:
        """Finalizer for rename operation."""
        self._set_new_name(target_name)
        if target_database is None:
            target_database = self.database.name
        if target_schema is None:
            target_schema = self.schema.name

        # Schema level resource
        if target_database != self.database.name or target_schema != self.schema.name:
            self.collection = getattr(self.root.databases[target_database].schemas[target_schema], self._plural_name)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Delete a password policy.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_password_policy(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_password_policy(
            self.database.name,
            self.schema.name,
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
