"""
Snowflake Procedure API.

The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated


class CallArgument(BaseModel):
    """A model object representing the CallArgument resource.

    Constructs an object of type CallArgument with the provided properties.

    Parameters
    __________
    name : str
        Name of the call argument
    datatype : str
        Call argument data type
    value : object
        Value of the call argument
    """

    name: Annotated[str, Field(strict=True)]

    datatype: StrictStr

    value: Optional[Any]

    __properties = ["name", "datatype", "value"]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CallArgument:
        """Create an instance of CallArgument from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # set to None if value (nullable) is None
        if self.value is None:
            _dict["value"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> CallArgument:
        """Create an instance of CallArgument from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CallArgument.model_validate(obj)

        _obj = CallArgument.model_validate(
            {
                "name": obj.get("name"),
                "datatype": obj.get("datatype"),
                "value": obj.get("value"),
            }
        )

        return _obj


class CallArgumentModel:
    def __init__(
        self,
        name: str,
        datatype: str,
        value: object,
        # optional properties
    ):
        """A model object representing the CallArgument resource.

        Constructs an object of type CallArgument with the provided properties.

        Parameters
        __________
        name : str
            Name of the call argument
        datatype : str
            Call argument data type
        value : object
            Value of the call argument
        """
        self.name = name
        self.datatype = datatype
        self.value = value

    __properties = ["name", "datatype", "value"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return CallArgument(
            name=self.name,
            datatype=self.datatype,
            value=self.value,
        )

    @classmethod
    def _from_model(cls, model) -> CallArgumentModel:
        return CallArgumentModel(
            name=model.name,
            datatype=model.datatype,
            value=model.value,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a CallArgument.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the CallArgument object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> CallArgumentModel:
        """Create an instance of CallArgument from a dict.

        This method constructs a CallArgument object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        CallArgument
            A CallArgument object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(CallArgument.from_dict(obj))


CallArgument._model_class = CallArgumentModel
