"""
Snowflake Procedure API.

The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.procedure._generated.models.base_language import BaseLanguage


class PythonFunction(BaseLanguage):
    """A model object representing the PythonFunction resource.

    Constructs an object of type PythonFunction with the provided properties.

    Parameters
    __________

    runtime_version : str
        Runtime version of the function's/procedure's specified language

    packages : list[str]
        Packages to include with the function/procedure

    handler : str
        Fully qualified method name including the package and the class

    imports : list[str], optional
        List of imports

    external_access_integrations : list[str], optional
        List of external access integrations attached to this function/procedure
    secrets : str, optional
        Secrets to be used with this function/procedure for external access
    """

    external_access_integrations: Optional[List[StrictStr]] = None

    secrets: Optional[Dict[str, StrictStr]] = None

    __properties = ["runtime_version", "packages", "imports", "handler", "language", "called_on_null_input"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PythonFunction:
        """Create an instance of PythonFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["language"] = BaseLanguage.get_child_model_discriminator_value("PythonFunction")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PythonFunction:
        """Create an instance of PythonFunction from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PythonFunction.model_validate(obj)

        _obj = PythonFunction.model_validate(
            {
                "runtime_version": obj.get("runtime_version"),
                "packages": obj.get("packages"),
                "imports": obj.get("imports"),
                "handler": obj.get("handler"),
                "external_access_integrations": obj.get("external_access_integrations"),
                "secrets": obj.get("secrets"),
            }
        )

        return _obj


class PythonFunctionModel(BaseLanguage):
    def __init__(
        self,
        runtime_version: str,
        packages: list[str],
        handler: str,  # optional properties
        called_on_null_input: Optional[bool] = None,
        external_access_integrations: Optional[list[str]] = None,
        secrets: Optional[str] = None,
    ):
        """A model object representing the PythonFunction resource.

        Constructs an object of type PythonFunction with the provided properties.

        Parameters
        __________

        runtime_version : str
            Runtime version of the function's/procedure's specified language

        packages : list[str]
            Packages to include with the function/procedure

        handler : str
            Fully qualified method name including the package and the class

        imports : list[str], optional
            List of imports

        external_access_integrations : list[str], optional
            List of external access integrations attached to this function/procedure
        secrets : str, optional
            Secrets to be used with this function/procedure for external access
        """
        super().__init__(
            called_on_null_input=called_on_null_input,
        )
        self.external_access_integrations = external_access_integrations
        self.secrets = secrets

    __properties = ["runtime_version", "packages", "imports", "handler", "language", "called_on_null_input"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PythonFunction(
            runtime_version=self.runtime_version,
            packages=self.packages,
            imports=self.imports,
            handler=self.handler,
            external_access_integrations=self.external_access_integrations,
            secrets=self.secrets,
        )

    @classmethod
    def _from_model(cls, model) -> PythonFunctionModel:
        return PythonFunctionModel(
            runtime_version=model.runtime_version,
            packages=model.packages,
            imports=model.imports,
            handler=model.handler,
            external_access_integrations=model.external_access_integrations,
            secrets=model.secrets,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PythonFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PythonFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PythonFunctionModel:
        """Create an instance of PythonFunction from a dict.

        This method constructs a PythonFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PythonFunction
            A PythonFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PythonFunction.from_dict(obj))


PythonFunction._model_class = PythonFunctionModel
