"""
Snowflake Procedure API.

The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict

from snowflake.core.procedure._generated.models.function_language import FunctionLanguage


class SQLFunction(FunctionLanguage):
    """A model object representing the SQLFunction resource.

    Constructs an object of type SQLFunction with the provided properties.

    Parameters
    __________

    called_on_null_input : bool, optional
        Decide if the function/procedure can receive null input
    """

    __properties = ["language", "called_on_null_input"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SQLFunction:
        """Create an instance of SQLFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["language"] = FunctionLanguage.get_child_model_discriminator_value("SQLFunction")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SQLFunction:
        """Create an instance of SQLFunction from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SQLFunction.model_validate(obj)

        _obj = SQLFunction.model_validate(
            {
                "called_on_null_input": obj.get("called_on_null_input"),
            }
        )

        return _obj


class SQLFunctionModel(FunctionLanguage):
    def __init__(
        self,  # optional properties
        called_on_null_input: Optional[bool] = None,
    ):
        """A model object representing the SQLFunction resource.

        Constructs an object of type SQLFunction with the provided properties.

        Parameters
        __________

        called_on_null_input : bool, optional
            Decide if the function/procedure can receive null input
        """
        super().__init__(
            called_on_null_input=called_on_null_input,
        )

    __properties = ["language", "called_on_null_input"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SQLFunction(
            called_on_null_input=self.called_on_null_input,
        )

    @classmethod
    def _from_model(cls, model) -> SQLFunctionModel:
        return SQLFunctionModel(
            called_on_null_input=model.called_on_null_input,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SQLFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SQLFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SQLFunctionModel:
        """Create an instance of SQLFunction from a dict.

        This method constructs a SQLFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SQLFunction
            A SQLFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SQLFunction.from_dict(obj))


SQLFunction._model_class = SQLFunctionModel
