"""
Snowflake Role API.

The Snowflake Role API is a REST API that you can use to access, update, and perform certain actions on Role resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing_extensions import Annotated


class Securable(BaseModel):
    """A model object representing the Securable resource.

    Constructs an object of type Securable with the provided properties.

    Parameters
    __________
    name : str
        Name of the securable if applicable.
    database : str, optional
        Database name of the securable if applicable.
    var_schema : str, optional
        Schema name of the securable if applicable.
    service : str, optional
        Service name of the securable if applicable.
    """

    database: Optional[Annotated[str, Field(strict=True)]] = None

    var_schema: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, alias="schema")

    service: Optional[Annotated[str, Field(strict=True)]] = None

    name: Annotated[str, Field(strict=True)]

    __properties = ["database", "schema", "service", "name"]

    @field_validator("database")
    def database_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("var_schema")
    def var_schema_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("service")
    def service_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Securable:
        """Create an instance of Securable from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Securable:
        """Create an instance of Securable from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Securable.model_validate(obj)

        _obj = Securable.model_validate(
            {
                "database": obj.get("database"),
                "var_schema": obj.get("schema"),
                "service": obj.get("service"),
                "name": obj.get("name"),
            }
        )

        return _obj


class SecurableModel:
    def __init__(
        self,
        name: str,
        # optional properties
        database: Optional[str] = None,
        var_schema: Optional[str] = None,
        service: Optional[str] = None,
    ):
        """A model object representing the Securable resource.

        Constructs an object of type Securable with the provided properties.

        Parameters
        __________
        name : str
            Name of the securable if applicable.
        database : str, optional
            Database name of the securable if applicable.
        var_schema : str, optional
            Schema name of the securable if applicable.
        service : str, optional
            Service name of the securable if applicable.
        """
        self.database = database
        self.var_schema = var_schema
        self.service = service
        self.name = name

    __properties = ["database", "schema", "service", "name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Securable(
            database=self.database,
            var_schema=self.var_schema,
            service=self.service,
            name=self.name,
        )

    @classmethod
    def _from_model(cls, model) -> SecurableModel:
        return SecurableModel(
            database=model.database,
            var_schema=model.var_schema,
            service=model.service,
            name=model.name,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Securable.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Securable object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SecurableModel:
        """Create an instance of Securable from a dict.

        This method constructs a Securable object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Securable
            A Securable object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Securable.from_dict(obj))


Securable._model_class = SecurableModel
