"""
Snowflake Secret API.

The Snowflake Secret API is a REST API that you can use to access, update, and perform certain actions on Secret resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, List, Optional

from pydantic import ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.secret._generated.models.secret import Secret


class Oauth2Secret(Secret):
    """A model object representing the Oauth2Secret resource.

    Constructs an object of type Oauth2Secret with the provided properties.

    Parameters
    __________

    name : str
        Name of the secret
    api_authentication : str
        API provider's authentication server integration name

    comment : str, optional
        user comment associated to an object in the dictionary

    created_on : datetime, optional
        Date and time when the secret was created — **Read-only:** *any user-provided value will be ignored.*

    database_name : str, optional
        Database in which the secret is stored — **Read-only:** *any user-provided value will be ignored.*

    schema_name : str, optional
        Schema in which the secret is stored — **Read-only:** *any user-provided value will be ignored.*

    owner : str, optional
        Role that owns the secret — **Read-only:** *any user-provided value will be ignored.*

    owner_role_type : str, optional
        The type of role that owns the secret — **Read-only:** *any user-provided value will be ignored.*

    oauth_refresh_token : str, optional
        OAuth secret refresh token
    oauth_refresh_token_expiry_time : str, optional
        Date or timestamp (UTC) when OAuth refresh token will expire. Possible formats: YYYY-MM-DD, YYYY-MM-DD HH24:MI:SS
    oauth_scopes : list[str], optional
        Scopes represented during OAuth Flow
    """

    oauth_refresh_token: Optional[StrictStr] = None

    oauth_refresh_token_expiry_time: Optional[StrictStr] = None

    oauth_scopes: Optional[List[StrictStr]] = None

    api_authentication: Annotated[str, Field(strict=True)]

    __properties = ["type", "comment", "name", "created_on", "database_name", "schema_name", "owner", "owner_role_type"]

    @field_validator("api_authentication")
    def api_authentication_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Oauth2Secret:
        """Create an instance of Oauth2Secret from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["type"] = Secret.get_child_model_discriminator_value("Oauth2Secret")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Oauth2Secret:
        """Create an instance of Oauth2Secret from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Oauth2Secret.model_validate(obj)

        _obj = Oauth2Secret.model_validate(
            {
                "comment": obj.get("comment"),
                "name": obj.get("name"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
                "oauth_refresh_token": obj.get("oauth_refresh_token"),
                "oauth_refresh_token_expiry_time": obj.get("oauth_refresh_token_expiry_time"),
                "oauth_scopes": obj.get("oauth_scopes"),
                "api_authentication": obj.get("api_authentication"),
            }
        )

        return _obj


class Oauth2SecretModel(Secret):
    def __init__(
        self,
        name: str,
        api_authentication: str,
        # optional properties
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        oauth_refresh_token: Optional[str] = None,
        oauth_refresh_token_expiry_time: Optional[str] = None,
        oauth_scopes: Optional[list[str]] = None,
    ):
        """A model object representing the Oauth2Secret resource.

        Constructs an object of type Oauth2Secret with the provided properties.

        Parameters
        __________

        name : str
            Name of the secret
        api_authentication : str
            API provider's authentication server integration name

        comment : str, optional
            user comment associated to an object in the dictionary

        created_on : datetime, optional
            Date and time when the secret was created.

        database_name : str, optional
            Database in which the secret is stored

        schema_name : str, optional
            Schema in which the secret is stored

        owner : str, optional
            Role that owns the secret

        owner_role_type : str, optional
            The type of role that owns the secret

        oauth_refresh_token : str, optional
            OAuth secret refresh token
        oauth_refresh_token_expiry_time : str, optional
            Date or timestamp (UTC) when OAuth refresh token will expire. Possible formats: YYYY-MM-DD, YYYY-MM-DD HH24:MI:SS
        oauth_scopes : list[str], optional
            Scopes represented during OAuth Flow
        """
        super().__init__(
            comment=comment,
            name=name,
            created_on=created_on,
            database_name=database_name,
            schema_name=schema_name,
            owner=owner,
            owner_role_type=owner_role_type,
        )
        self.oauth_refresh_token = oauth_refresh_token
        self.oauth_refresh_token_expiry_time = oauth_refresh_token_expiry_time
        self.oauth_scopes = oauth_scopes
        self.api_authentication = api_authentication

    __properties = ["type", "comment", "name", "created_on", "database_name", "schema_name", "owner", "owner_role_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Oauth2Secret(
            comment=self.comment,
            name=self.name,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            oauth_refresh_token=self.oauth_refresh_token,
            oauth_refresh_token_expiry_time=self.oauth_refresh_token_expiry_time,
            oauth_scopes=self.oauth_scopes,
            api_authentication=self.api_authentication,
        )

    @classmethod
    def _from_model(cls, model) -> Oauth2SecretModel:
        return Oauth2SecretModel(
            comment=model.comment,
            name=model.name,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            oauth_refresh_token=model.oauth_refresh_token,
            oauth_refresh_token_expiry_time=model.oauth_refresh_token_expiry_time,
            oauth_scopes=model.oauth_scopes,
            api_authentication=model.api_authentication,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Oauth2Secret.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Oauth2Secret object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> Oauth2SecretModel:
        """Create an instance of Oauth2Secret from a dict.

        This method constructs a Oauth2Secret object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Oauth2Secret
            A Oauth2Secret object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Oauth2Secret.from_dict(obj))


Oauth2Secret._model_class = Oauth2SecretModel
