"""
Snowflake Secret API.

The Snowflake Secret API is a REST API that you can use to access, update, and perform certain actions on Secret resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from datetime import datetime
from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.secret._generated.models.secret import Secret


class PasswordSecret(Secret):
    """A model object representing the PasswordSecret resource.

    Constructs an object of type PasswordSecret with the provided properties.

    Parameters
    __________

    name : str
        Name of the secret
    username : str
        Name of the user.
    password : str
        Password of the user

    comment : str, optional
        user comment associated to an object in the dictionary

    created_on : datetime, optional
        Date and time when the secret was created — **Read-only:** *any user-provided value will be ignored.*

    database_name : str, optional
        Database in which the secret is stored — **Read-only:** *any user-provided value will be ignored.*

    schema_name : str, optional
        Schema in which the secret is stored — **Read-only:** *any user-provided value will be ignored.*

    owner : str, optional
        Role that owns the secret — **Read-only:** *any user-provided value will be ignored.*

    owner_role_type : str, optional
        The type of role that owns the secret — **Read-only:** *any user-provided value will be ignored.*
    """

    username: StrictStr

    password: StrictStr

    __properties = ["type", "comment", "name", "created_on", "database_name", "schema_name", "owner", "owner_role_type"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PasswordSecret:
        """Create an instance of PasswordSecret from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["type"] = Secret.get_child_model_discriminator_value("PasswordSecret")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PasswordSecret:
        """Create an instance of PasswordSecret from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PasswordSecret.model_validate(obj)

        _obj = PasswordSecret.model_validate(
            {
                "comment": obj.get("comment"),
                "name": obj.get("name"),
                "created_on": obj.get("created_on"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
                "username": obj.get("username"),
                "password": obj.get("password"),
            }
        )

        return _obj


class PasswordSecretModel(Secret):
    def __init__(
        self,
        name: str,
        username: str,
        password: str,
        # optional properties
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the PasswordSecret resource.

        Constructs an object of type PasswordSecret with the provided properties.

        Parameters
        __________

        name : str
            Name of the secret
        username : str
            Name of the user.
        password : str
            Password of the user

        comment : str, optional
            user comment associated to an object in the dictionary

        created_on : datetime, optional
            Date and time when the secret was created.

        database_name : str, optional
            Database in which the secret is stored

        schema_name : str, optional
            Schema in which the secret is stored

        owner : str, optional
            Role that owns the secret

        owner_role_type : str, optional
            The type of role that owns the secret
        """
        super().__init__(
            comment=comment,
            name=name,
            created_on=created_on,
            database_name=database_name,
            schema_name=schema_name,
            owner=owner,
            owner_role_type=owner_role_type,
        )
        self.username = username
        self.password = password

    __properties = ["type", "comment", "name", "created_on", "database_name", "schema_name", "owner", "owner_role_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PasswordSecret(
            comment=self.comment,
            name=self.name,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            username=self.username,
            password=self.password,
        )

    @classmethod
    def _from_model(cls, model) -> PasswordSecretModel:
        return PasswordSecretModel(
            comment=model.comment,
            name=model.name,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            username=model.username,
            password=model.password,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a PasswordSecret.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PasswordSecret object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PasswordSecretModel:
        """Create an instance of PasswordSecret from a dict.

        This method constructs a PasswordSecret object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PasswordSecret
            A PasswordSecret object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PasswordSecret.from_dict(obj))


PasswordSecret._model_class = PasswordSecretModel
