"""
Snowflake Session API.

The Snowflake Session API is a REST API that you can use to query your current session properties.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictStr


class Parameter(BaseModel):
    """A model object representing the Parameter resource.

    Constructs an object of type Parameter with the provided properties.

    Parameters
    __________
    name : str
        Parameter name.
    value : str, optional
        Parameter value.
    default_value : str, optional
        Default parameter value.
    data_type : str, optional
        Data type of the parameter value. Either BOOLEAN, NUMBER, FLOAT, or STRING.
    level : str, optional
        Level at which parameter is defined.
    description : str, optional
        Parameter description.
    """

    name: StrictStr

    value: Optional[StrictStr] = None

    default_value: Optional[StrictStr] = Field(default=None, alias="defaultValue")

    data_type: Optional[StrictStr] = Field(default=None, alias="dataType")

    level: Optional[StrictStr] = None

    description: Optional[StrictStr] = None

    __properties = ["name", "value", "defaultValue", "dataType", "level", "description"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Parameter:
        """Create an instance of Parameter from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Parameter:
        """Create an instance of Parameter from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Parameter.model_validate(obj)

        _obj = Parameter.model_validate(
            {
                "name": obj.get("name"),
                "value": obj.get("value"),
                "default_value": obj.get("defaultValue"),
                "data_type": obj.get("dataType"),
                "level": obj.get("level"),
                "description": obj.get("description"),
            }
        )

        return _obj


class ParameterModel:
    def __init__(
        self,
        name: str,
        # optional properties
        value: Optional[str] = None,
        default_value: Optional[str] = None,
        data_type: Optional[str] = None,
        level: Optional[str] = None,
        description: Optional[str] = None,
    ):
        """A model object representing the Parameter resource.

        Constructs an object of type Parameter with the provided properties.

        Parameters
        __________
        name : str
            Parameter name.
        value : str, optional
            Parameter value.
        default_value : str, optional
            Default parameter value.
        data_type : str, optional
            Data type of the parameter value. Either BOOLEAN, NUMBER, FLOAT, or STRING.
        level : str, optional
            Level at which parameter is defined.
        description : str, optional
            Parameter description.
        """
        self.name = name
        self.value = value
        self.default_value = default_value
        self.data_type = data_type
        self.level = level
        self.description = description

    __properties = ["name", "value", "defaultValue", "dataType", "level", "description"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Parameter(
            name=self.name,
            value=self.value,
            default_value=self.default_value,
            data_type=self.data_type,
            level=self.level,
            description=self.description,
        )

    @classmethod
    def _from_model(cls, model) -> ParameterModel:
        return ParameterModel(
            name=model.name,
            value=model.value,
            default_value=model.default_value,
            data_type=model.data_type,
            level=model.level,
            description=model.description,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Parameter.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Parameter object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ParameterModel:
        """Create an instance of Parameter from a dict.

        This method constructs a Parameter object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Parameter
            A Parameter object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Parameter.from_dict(obj))


Parameter._model_class = ParameterModel
