"""
Snowflake Stage API.

The Snowflake Stage API is a REST API that you can use to access, update, and perform certain actions on stage resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class StageFile(BaseModel):
    """A model object representing the StageFile resource.

    Constructs an object of type StageFile with the provided properties.

    Parameters
    __________
    name : str, optional
        Name of the file.
    size : str, optional
        Size of the file — **Read-only:** *any user-provided value will be ignored.*
    md5 : str, optional
        md5 hash of the file — **Read-only:** *any user-provided value will be ignored.*
    last_modified : str, optional
        Date and time when the file was last modified — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Optional[StrictStr] = None

    size: Optional[StrictStr] = None

    md5: Optional[StrictStr] = None

    last_modified: Optional[StrictStr] = None

    __properties = ["name", "size", "md5", "last_modified"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StageFile:
        """Create an instance of StageFile from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "size",
                    "md5",
                    "last_modified",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StageFile:
        """Create an instance of StageFile from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StageFile.model_validate(obj)

        _obj = StageFile.model_validate(
            {
                "name": obj.get("name"),
                "size": obj.get("size"),
                "md5": obj.get("md5"),
                "last_modified": obj.get("last_modified"),
            }
        )

        return _obj


class StageFileModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        size: Optional[str] = None,
        md5: Optional[str] = None,
        last_modified: Optional[str] = None,
    ):
        """A model object representing the StageFile resource.

        Constructs an object of type StageFile with the provided properties.

        Parameters
        __________
        name : str, optional
            Name of the file.
        size : str, optional
            Size of the file.
        md5 : str, optional
            md5 hash of the file.
        last_modified : str, optional
            Date and time when the file was last modified.
        """
        self.name = name
        self.size = size
        self.md5 = md5
        self.last_modified = last_modified

    __properties = ["name", "size", "md5", "last_modified"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StageFile(
            name=self.name,
            size=self.size,
            md5=self.md5,
            last_modified=self.last_modified,
        )

    @classmethod
    def _from_model(cls, model) -> StageFileModel:
        return StageFileModel(
            name=model.name,
            size=model.size,
            md5=model.md5,
            last_modified=model.last_modified,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a StageFile.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StageFile object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StageFileModel:
        """Create an instance of StageFile from a dict.

        This method constructs a StageFile object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StageFile
            A StageFile object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StageFile.from_dict(obj))


StageFile._model_class = StageFileModel
