"""
Snowflake Stream API.

The Snowflake Stream API is a REST API that you can use to access, update, and perform certain actions on Stream resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.stream._generated.models.stream_source import StreamSource, StreamSourceModel


class Stream(BaseModel):
    """A model object representing the Stream resource.

    Constructs an object of type Stream with the provided properties.

    Parameters
    __________
    name : str
        Name of the stream
    stream_source : StreamSource

    created_on : datetime, optional
        Date and time when the stream was created — **Read-only:** *any user-provided value will be ignored.*
    comment : str, optional
        user comment associated to an object in the dictionary
    database_name : str, optional
        Database in which the stream is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the stream is stored — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the stream — **Read-only:** *any user-provided value will be ignored.*
    table_name : str, optional
        Table name whose changes are tracked by the stream — **Read-only:** *any user-provided value will be ignored.*
    stale : bool, optional
        Specifies whether the stream is stale or not — **Read-only:** *any user-provided value will be ignored.*
    mode : str, optional
        Mode of the stream. Possible values include: APPEND_ONLY, INSERT_ONLY. For streams on tables, the column displays DEFAULT — **Read-only:** *any user-provided value will be ignored.*
    stale_after : datetime, optional
        Timestamp when the stream became stale or may become stale if not consumed — **Read-only:** *any user-provided value will be ignored.*
    invalid_reason : str, optional
        Reason why the stream cannot be queried successfully. This column supports future functionality. Currently, the only value returned is N/A — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the stream — **Read-only:** *any user-provided value will be ignored.*
    type : str, optional
        Type of the stream; currently DELTA only — **Read-only:** *any user-provided value will be ignored.*
    """

    created_on: Optional[datetime] = None

    name: Annotated[str, Field(strict=True)]

    stream_source: StreamSource

    comment: Optional[StrictStr] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    table_name: Optional[Annotated[str, Field(strict=True)]] = None

    stale: Optional[StrictBool] = None

    mode: Optional[StrictStr] = None

    stale_after: Optional[datetime] = None

    invalid_reason: Optional[StrictStr] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    type: Optional[StrictStr] = None

    __properties = [
        "created_on",
        "name",
        "stream_source",
        "comment",
        "database_name",
        "schema_name",
        "owner",
        "table_name",
        "stale",
        "mode",
        "stale_after",
        "invalid_reason",
        "owner_role_type",
        "type",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("table_name")
    def table_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner_role_type")
    def owner_role_type_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Stream:
        """Create an instance of Stream from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "created_on",
                    "database_name",
                    "schema_name",
                    "owner",
                    "table_name",
                    "stale",
                    "mode",
                    "stale_after",
                    "invalid_reason",
                    "owner_role_type",
                    "type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of stream_source
        if self.stream_source:
            _dict["stream_source"] = self.stream_source.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Stream:
        """Create an instance of Stream from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Stream.model_validate(obj)

        _obj = Stream.model_validate(
            {
                "created_on": obj.get("created_on"),
                "name": obj.get("name"),
                "stream_source": StreamSource.from_dict(obj.get("stream_source"))
                if obj.get("stream_source") is not None
                else None,
                "comment": obj.get("comment"),
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "table_name": obj.get("table_name"),
                "stale": obj.get("stale"),
                "mode": obj.get("mode"),
                "stale_after": obj.get("stale_after"),
                "invalid_reason": obj.get("invalid_reason"),
                "owner_role_type": obj.get("owner_role_type"),
                "type": obj.get("type"),
            }
        )

        return _obj


class StreamModel:
    def __init__(
        self,
        name: str,
        stream_source: StreamSource,
        # optional properties
        created_on: Optional[datetime] = None,
        comment: Optional[str] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        table_name: Optional[str] = None,
        stale: Optional[bool] = None,
        mode: Optional[str] = None,
        stale_after: Optional[datetime] = None,
        invalid_reason: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        type: Optional[str] = None,
    ):
        """A model object representing the Stream resource.

        Constructs an object of type Stream with the provided properties.

        Parameters
        __________
        name : str
            Name of the stream
        stream_source : StreamSource

        created_on : datetime, optional
            Date and time when the stream was created.
        comment : str, optional
            user comment associated to an object in the dictionary
        database_name : str, optional
            Database in which the stream is stored
        schema_name : str, optional
            Schema in which the stream is stored
        owner : str, optional
            Role that owns the stream
        table_name : str, optional
            Table name whose changes are tracked by the stream
        stale : bool, optional
            Specifies whether the stream is stale or not
        mode : str, optional
            Mode of the stream. Possible values include: APPEND_ONLY, INSERT_ONLY. For streams on tables, the column displays DEFAULT.
        stale_after : datetime, optional
            Timestamp when the stream became stale or may become stale if not consumed.
        invalid_reason : str, optional
            Reason why the stream cannot be queried successfully. This column supports future functionality. Currently, the only value returned is N/A.
        owner_role_type : str, optional
            The type of role that owns the stream
        type : str, optional
            Type of the stream; currently DELTA only.
        """
        self.created_on = created_on
        self.name = name
        self.stream_source = stream_source
        self.comment = comment
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.table_name = table_name
        self.stale = stale
        self.mode = mode
        self.stale_after = stale_after
        self.invalid_reason = invalid_reason
        self.owner_role_type = owner_role_type
        self.type = type

    __properties = [
        "created_on",
        "name",
        "stream_source",
        "comment",
        "database_name",
        "schema_name",
        "owner",
        "table_name",
        "stale",
        "mode",
        "stale_after",
        "invalid_reason",
        "owner_role_type",
        "type",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Stream(
            created_on=self.created_on,
            name=self.name,
            stream_source=self.stream_source._to_model() if self.stream_source is not None else None,
            comment=self.comment,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            table_name=self.table_name,
            stale=self.stale,
            mode=self.mode,
            stale_after=self.stale_after,
            invalid_reason=self.invalid_reason,
            owner_role_type=self.owner_role_type,
            type=self.type,
        )

    @classmethod
    def _from_model(cls, model) -> StreamModel:
        return StreamModel(
            created_on=model.created_on,
            name=model.name,
            stream_source=StreamSourceModel._from_model(model.stream_source) if model.stream_source else None,
            comment=model.comment,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            table_name=model.table_name,
            stale=model.stale,
            mode=model.mode,
            stale_after=model.stale_after,
            invalid_reason=model.invalid_reason,
            owner_role_type=model.owner_role_type,
            type=model.type,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Stream.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Stream object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamModel:
        """Create an instance of Stream from a dict.

        This method constructs a Stream object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Stream
            A Stream object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Stream.from_dict(obj))


Stream._model_class = StreamModel
