"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class AddLiveVersionStreamlitRequestVersion(BaseModel):
    """A model object representing the AddLiveVersionStreamlitRequestVersion resource.

    Constructs an object of type AddLiveVersionStreamlitRequestVersion with the provided properties.

    Parameters
    __________
    name : str, optional
        Optional alias name for the live version.
    comment : str, optional
        Optional comment for the live version.
    """

    name: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    __properties = ["name", "comment"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddLiveVersionStreamlitRequestVersion:
        """Create an instance of AddLiveVersionStreamlitRequestVersion from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AddLiveVersionStreamlitRequestVersion:
        """Create an instance of AddLiveVersionStreamlitRequestVersion from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddLiveVersionStreamlitRequestVersion.model_validate(obj)

        _obj = AddLiveVersionStreamlitRequestVersion.model_validate(
            {
                "name": obj.get("name"),
                "comment": obj.get("comment"),
            }
        )

        return _obj


class AddLiveVersionStreamlitRequestVersionModel:
    def __init__(
        self,  # optional properties
        name: Optional[str] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the AddLiveVersionStreamlitRequestVersion resource.

        Constructs an object of type AddLiveVersionStreamlitRequestVersion with the provided properties.

        Parameters
        __________
        name : str, optional
            Optional alias name for the live version.
        comment : str, optional
            Optional comment for the live version.
        """
        self.name = name
        self.comment = comment

    __properties = ["name", "comment"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AddLiveVersionStreamlitRequestVersion(
            name=self.name,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> AddLiveVersionStreamlitRequestVersionModel:
        return AddLiveVersionStreamlitRequestVersionModel(
            name=model.name,
            comment=model.comment,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AddLiveVersionStreamlitRequestVersion.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AddLiveVersionStreamlitRequestVersion object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AddLiveVersionStreamlitRequestVersionModel:
        """Create an instance of AddLiveVersionStreamlitRequestVersion from a dict.

        This method constructs a AddLiveVersionStreamlitRequestVersion object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AddLiveVersionStreamlitRequestVersion
            A AddLiveVersionStreamlitRequestVersion object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AddLiveVersionStreamlitRequestVersion.from_dict(obj))


AddLiveVersionStreamlitRequestVersion._model_class = AddLiveVersionStreamlitRequestVersionModel
