"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr


class AddVersionStreamlitRequestVersion(BaseModel):
    """A model object representing the AddVersionStreamlitRequestVersion resource.

    Constructs an object of type AddVersionStreamlitRequestVersion with the provided properties.

    Parameters
    __________
    name : str
        Name/Alias for the new version.
    comment : str, optional

    if_not_exists : bool, optional
    """

    name: StrictStr

    comment: Optional[StrictStr] = None

    if_not_exists: Optional[StrictBool] = Field(default=None, alias="ifNotExists")

    __properties = ["name", "comment", "ifNotExists"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddVersionStreamlitRequestVersion:
        """Create an instance of AddVersionStreamlitRequestVersion from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AddVersionStreamlitRequestVersion:
        """Create an instance of AddVersionStreamlitRequestVersion from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddVersionStreamlitRequestVersion.model_validate(obj)

        _obj = AddVersionStreamlitRequestVersion.model_validate(
            {
                "name": obj.get("name"),
                "comment": obj.get("comment"),
                "if_not_exists": obj.get("ifNotExists"),
            }
        )

        return _obj


class AddVersionStreamlitRequestVersionModel:
    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        if_not_exists: Optional[bool] = None,
    ):
        """A model object representing the AddVersionStreamlitRequestVersion resource.

        Constructs an object of type AddVersionStreamlitRequestVersion with the provided properties.

        Parameters
        __________
        name : str
            Name/Alias for the new version.
        comment : str, optional

        if_not_exists : bool, optional
        """
        self.name = name
        self.comment = comment
        self.if_not_exists = if_not_exists

    __properties = ["name", "comment", "ifNotExists"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AddVersionStreamlitRequestVersion(
            name=self.name,
            comment=self.comment,
            if_not_exists=self.if_not_exists,
        )

    @classmethod
    def _from_model(cls, model) -> AddVersionStreamlitRequestVersionModel:
        return AddVersionStreamlitRequestVersionModel(
            name=model.name,
            comment=model.comment,
            if_not_exists=model.if_not_exists,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AddVersionStreamlitRequestVersion.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AddVersionStreamlitRequestVersion object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AddVersionStreamlitRequestVersionModel:
        """Create an instance of AddVersionStreamlitRequestVersion from a dict.

        This method constructs a AddVersionStreamlitRequestVersion object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AddVersionStreamlitRequestVersion
            A AddVersionStreamlitRequestVersion object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AddVersionStreamlitRequestVersion.from_dict(obj))


AddVersionStreamlitRequestVersion._model_class = AddVersionStreamlitRequestVersionModel
