"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import ConfigDict, StrictStr

from snowflake.core.streamlit._generated.models.streamlit_push_options import (
    StreamlitPushOptions,
)


class GitPushWithUsernamePassword(StreamlitPushOptions):
    """A model object representing the GitPushWithUsernamePassword resource.

    Constructs an object of type GitPushWithUsernamePassword with the provided properties.

    Parameters
    __________
    git_username : str
        A Git username.
    git_password : str
        A Git password.
    git_author_name : str
        The name of the Git author.
    git_author_email : str
        The email of the Git author.
    to_git_branch_uri : str, optional
        Pushes committed changes to the specified branch.
    git_push_comment : str, optional
        A comment to include in the Git push.
    """

    git_username: StrictStr

    git_password: StrictStr

    git_author_name: StrictStr

    git_author_email: StrictStr

    to_git_branch_uri: Optional[StrictStr] = None

    git_push_comment: Optional[StrictStr] = None

    __properties = ["auth_type"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GitPushWithUsernamePassword:
        """Create an instance of GitPushWithUsernamePassword from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["auth_type"] = StreamlitPushOptions.get_child_model_discriminator_value("GitPushWithUsernamePassword")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> GitPushWithUsernamePassword:
        """Create an instance of GitPushWithUsernamePassword from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GitPushWithUsernamePassword.model_validate(obj)

        _obj = GitPushWithUsernamePassword.model_validate(
            {
                "git_username": obj.get("git_username"),
                "git_password": obj.get("git_password"),
                "git_author_name": obj.get("git_author_name"),
                "git_author_email": obj.get("git_author_email"),
                "to_git_branch_uri": obj.get("to_git_branch_uri"),
                "git_push_comment": obj.get("git_push_comment"),
            }
        )

        return _obj


class GitPushWithUsernamePasswordModel(StreamlitPushOptions):
    def __init__(
        self,
        git_username: str,
        git_password: str,
        git_author_name: str,
        git_author_email: str,
        # optional properties
        to_git_branch_uri: Optional[str] = None,
        git_push_comment: Optional[str] = None,
    ):
        """A model object representing the GitPushWithUsernamePassword resource.

        Constructs an object of type GitPushWithUsernamePassword with the provided properties.

        Parameters
        __________
        git_username : str
            A Git username.
        git_password : str
            A Git password.
        git_author_name : str
            The name of the Git author.
        git_author_email : str
            The email of the Git author.
        to_git_branch_uri : str, optional
            Pushes committed changes to the specified branch.
        git_push_comment : str, optional
            A comment to include in the Git push.
        """
        super().__init__()
        self.git_username = git_username
        self.git_password = git_password
        self.git_author_name = git_author_name
        self.git_author_email = git_author_email
        self.to_git_branch_uri = to_git_branch_uri
        self.git_push_comment = git_push_comment

    __properties = ["auth_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return GitPushWithUsernamePassword(
            git_username=self.git_username,
            git_password=self.git_password,
            git_author_name=self.git_author_name,
            git_author_email=self.git_author_email,
            to_git_branch_uri=self.to_git_branch_uri,
            git_push_comment=self.git_push_comment,
        )

    @classmethod
    def _from_model(cls, model) -> GitPushWithUsernamePasswordModel:
        return GitPushWithUsernamePasswordModel(
            git_username=model.git_username,
            git_password=model.git_password,
            git_author_name=model.git_author_name,
            git_author_email=model.git_author_email,
            to_git_branch_uri=model.to_git_branch_uri,
            git_push_comment=model.git_push_comment,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a GitPushWithUsernamePassword.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the GitPushWithUsernamePassword object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> GitPushWithUsernamePasswordModel:
        """Create an instance of GitPushWithUsernamePassword from a dict.

        This method constructs a GitPushWithUsernamePassword object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        GitPushWithUsernamePassword
            A GitPushWithUsernamePassword object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(GitPushWithUsernamePassword.from_dict(obj))


GitPushWithUsernamePassword._model_class = GitPushWithUsernamePasswordModel
