"""
Snowflake Streamlit API.

The Snowflake Streamlit API is a REST API that you can use to access, update, and perform certain actions on Streamlit resources in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated

from snowflake.core.streamlit._generated.models.version_details_streamlit import (
    VersionDetailsStreamlit,
    VersionDetailsStreamlitModel,
)


class Streamlit(BaseModel):
    """A model object representing the Streamlit resource.

    Constructs an object of type Streamlit with the provided properties.

    Parameters
    __________
    name : str
        Name of the Streamlit
    comment : str, optional
        Optional description of the Streamlit app, used for documentation or metadata purposes
    imports : list[str], optional
        List of files to be imported from a stage.
    external_access_integrations : list[str], optional
        List of external access integrations needed in order for the Streamlit app code to access external networks.
    external_access_secrets : str, optional
        Secrets needed for the Streamlit app code to access external networks — **Read-only:** *any user-provided value will be ignored.*
    title : str, optional
        User-facing title of the Streamlit app.
    main_file : str, optional
        Name and path of the entry file for the Streamlit app
    query_warehouse : str, optional
        Warehouse used to run queries issued by the Streamlit app
    default_version : str, optional
        The default version name of Streamlit. Valid values are "first" (first version), "last" (latest version), or "version$N" (specific version, e.g., "version$1"). Custom names are not supported.
    created_on : datetime, optional
        Date and time when the Streamlit was created — **Read-only:** *any user-provided value will be ignored.*
    default_version_details : VersionDetailsStreamlit, optional

    last_version_details : VersionDetailsStreamlit, optional

    database_name : str, optional
        Database in which the Streamlit is stored — **Read-only:** *any user-provided value will be ignored.*
    schema_name : str, optional
        Schema in which the Streamlit is stored — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the Streamlit — **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the Streamlit — **Read-only:** *any user-provided value will be ignored.*
    source_location : str, optional
        The stage from which the source files are copied to initialize the Streamlit app.
    url_id : str, optional
        A unique ID associated with the Streamlit object's URL — **Read-only:** *any user-provided value will be ignored.*
    default_packages : list[str], optional
        Default Python packages for Streamlit apps — **Read-only:** *any user-provided value will be ignored.*
    user_packages : list[str], optional
        Python packages specified in the environment.yml file — **Read-only:** *any user-provided value will be ignored.*
    live_version_location_uri : str, optional
        The location of the Streamlit object's live version files — **Read-only:** *any user-provided value will be ignored.*
    """

    name: Annotated[str, Field(strict=True)]

    comment: Optional[StrictStr] = None

    imports: Optional[List[StrictStr]] = None

    external_access_integrations: Optional[List[StrictStr]] = None

    external_access_secrets: Optional[StrictStr] = None

    title: Optional[StrictStr] = None

    main_file: Optional[StrictStr] = None

    query_warehouse: Optional[StrictStr] = None

    default_version: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    default_version_details: Optional[VersionDetailsStreamlit] = None

    last_version_details: Optional[VersionDetailsStreamlit] = None

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    owner: Optional[Annotated[str, Field(strict=True)]] = None

    owner_role_type: Optional[Annotated[str, Field(strict=True)]] = None

    source_location: Optional[StrictStr] = None

    url_id: Optional[StrictStr] = None

    default_packages: Optional[List[StrictStr]] = None

    user_packages: Optional[List[StrictStr]] = None

    live_version_location_uri: Optional[StrictStr] = None

    __properties = [
        "name",
        "comment",
        "imports",
        "external_access_integrations",
        "external_access_secrets",
        "title",
        "main_file",
        "query_warehouse",
        "default_version",
        "created_on",
        "default_version_details",
        "last_version_details",
        "database_name",
        "schema_name",
        "owner",
        "owner_role_type",
        "source_location",
        "url_id",
        "default_packages",
        "user_packages",
        "live_version_location_uri",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("database_name")
    def database_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("schema_name")
    def schema_name_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner")
    def owner_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("owner_role_type")
    def owner_role_type_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Streamlit:
        """Create an instance of Streamlit from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "external_access_secrets",
                    "created_on",
                    "database_name",
                    "schema_name",
                    "owner",
                    "owner_role_type",
                    "url_id",
                    "default_packages",
                    "user_packages",
                    "live_version_location_uri",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of default_version_details
        if self.default_version_details:
            _dict["default_version_details"] = self.default_version_details.to_dict()

        # override the default output from pydantic by calling `to_dict()` of last_version_details
        if self.last_version_details:
            _dict["last_version_details"] = self.last_version_details.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Streamlit:
        """Create an instance of Streamlit from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Streamlit.model_validate(obj)

        _obj = Streamlit.model_validate(
            {
                "name": obj.get("name"),
                "comment": obj.get("comment"),
                "imports": obj.get("imports"),
                "external_access_integrations": obj.get("external_access_integrations"),
                "external_access_secrets": obj.get("external_access_secrets"),
                "title": obj.get("title"),
                "main_file": obj.get("main_file"),
                "query_warehouse": obj.get("query_warehouse"),
                "default_version": obj.get("default_version"),
                "created_on": obj.get("created_on"),
                "default_version_details": VersionDetailsStreamlit.from_dict(obj.get("default_version_details"))
                if obj.get("default_version_details") is not None
                else None,
                "last_version_details": VersionDetailsStreamlit.from_dict(obj.get("last_version_details"))
                if obj.get("last_version_details") is not None
                else None,
                "database_name": obj.get("database_name"),
                "schema_name": obj.get("schema_name"),
                "owner": obj.get("owner"),
                "owner_role_type": obj.get("owner_role_type"),
                "source_location": obj.get("source_location"),
                "url_id": obj.get("url_id"),
                "default_packages": obj.get("default_packages"),
                "user_packages": obj.get("user_packages"),
                "live_version_location_uri": obj.get("live_version_location_uri"),
            }
        )

        return _obj


class StreamlitModel:
    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
        imports: Optional[list[str]] = None,
        external_access_integrations: Optional[list[str]] = None,
        external_access_secrets: Optional[str] = None,
        title: Optional[str] = None,
        main_file: Optional[str] = None,
        query_warehouse: Optional[str] = None,
        default_version: Optional[str] = None,
        created_on: Optional[datetime] = None,
        default_version_details: Optional[VersionDetailsStreamlit] = None,
        last_version_details: Optional[VersionDetailsStreamlit] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        source_location: Optional[str] = None,
        url_id: Optional[str] = None,
        default_packages: Optional[list[str]] = None,
        user_packages: Optional[list[str]] = None,
        live_version_location_uri: Optional[str] = None,
    ):
        """A model object representing the Streamlit resource.

        Constructs an object of type Streamlit with the provided properties.

        Parameters
        __________
        name : str
            Name of the Streamlit
        comment : str, optional
            Optional description of the Streamlit app, used for documentation or metadata purposes
        imports : list[str], optional
            List of files to be imported from a stage.
        external_access_integrations : list[str], optional
            List of external access integrations needed in order for the Streamlit app code to access external networks.
        external_access_secrets : str, optional
            Secrets needed for the Streamlit app code to access external networks.
        title : str, optional
            User-facing title of the Streamlit app.
        main_file : str, optional
            Name and path of the entry file for the Streamlit app
        query_warehouse : str, optional
            Warehouse used to run queries issued by the Streamlit app
        default_version : str, optional
            The default version name of Streamlit. Valid values are "first" (first version), "last" (latest version), or "version$N" (specific version, e.g., "version$1"). Custom names are not supported.
        created_on : datetime, optional
            Date and time when the Streamlit was created.
        default_version_details : VersionDetailsStreamlit, optional

        last_version_details : VersionDetailsStreamlit, optional

        database_name : str, optional
            Database in which the Streamlit is stored
        schema_name : str, optional
            Schema in which the Streamlit is stored
        owner : str, optional
            Role that owns the Streamlit
        owner_role_type : str, optional
            The type of role that owns the Streamlit
        source_location : str, optional
            The stage from which the source files are copied to initialize the Streamlit app.
        url_id : str, optional
            A unique ID associated with the Streamlit object's URL.
        default_packages : list[str], optional
            Default Python packages for Streamlit apps.
        user_packages : list[str], optional
            Python packages specified in the environment.yml file.
        live_version_location_uri : str, optional
            The location of the Streamlit object's live version files.
        """
        self.name = name
        self.comment = comment
        self.imports = imports
        self.external_access_integrations = external_access_integrations
        self.external_access_secrets = external_access_secrets
        self.title = title
        self.main_file = main_file
        self.query_warehouse = query_warehouse
        self.default_version = default_version
        self.created_on = created_on
        self.default_version_details = default_version_details
        self.last_version_details = last_version_details
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type
        self.source_location = source_location
        self.url_id = url_id
        self.default_packages = default_packages
        self.user_packages = user_packages
        self.live_version_location_uri = live_version_location_uri

    __properties = [
        "name",
        "comment",
        "imports",
        "external_access_integrations",
        "external_access_secrets",
        "title",
        "main_file",
        "query_warehouse",
        "default_version",
        "created_on",
        "default_version_details",
        "last_version_details",
        "database_name",
        "schema_name",
        "owner",
        "owner_role_type",
        "source_location",
        "url_id",
        "default_packages",
        "user_packages",
        "live_version_location_uri",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Streamlit(
            name=self.name,
            comment=self.comment,
            imports=self.imports,
            external_access_integrations=self.external_access_integrations,
            external_access_secrets=self.external_access_secrets,
            title=self.title,
            main_file=self.main_file,
            query_warehouse=self.query_warehouse,
            default_version=self.default_version,
            created_on=self.created_on,
            default_version_details=self.default_version_details._to_model()
            if self.default_version_details is not None
            else None,
            last_version_details=self.last_version_details._to_model()
            if self.last_version_details is not None
            else None,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
            source_location=self.source_location,
            url_id=self.url_id,
            default_packages=self.default_packages,
            user_packages=self.user_packages,
            live_version_location_uri=self.live_version_location_uri,
        )

    @classmethod
    def _from_model(cls, model) -> StreamlitModel:
        return StreamlitModel(
            name=model.name,
            comment=model.comment,
            imports=model.imports,
            external_access_integrations=model.external_access_integrations,
            external_access_secrets=model.external_access_secrets,
            title=model.title,
            main_file=model.main_file,
            query_warehouse=model.query_warehouse,
            default_version=model.default_version,
            created_on=model.created_on,
            default_version_details=VersionDetailsStreamlitModel._from_model(model.default_version_details)
            if model.default_version_details
            else None,
            last_version_details=VersionDetailsStreamlitModel._from_model(model.last_version_details)
            if model.last_version_details
            else None,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
            source_location=model.source_location,
            url_id=model.url_id,
            default_packages=model.default_packages,
            user_packages=model.user_packages,
            live_version_location_uri=model.live_version_location_uri,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Streamlit.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Streamlit object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamlitModel:
        """Create an instance of Streamlit from a dict.

        This method constructs a Streamlit object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Streamlit
            A Streamlit object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Streamlit.from_dict(obj))


Streamlit._model_class = StreamlitModel
