"""
Snowflake Tag API.

The Snowflake Tag API is a REST API that you can use to access, update, and perform certain actions on Tag resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class ErrorResponse(BaseModel):
    """A model object representing the ErrorResponse resource.

    Constructs an object of type ErrorResponse with the provided properties.

    Parameters
    __________
    message : str, optional
        Error message returned by the server
    code : str, optional
        Error code.
    error_code : str, optional
        Error code, same as `code` above. This property has been deprecated and will be removed in a future release, but is temporarily supported for for short-term backward compatibility.
    request_id : str, optional
        Unique request ID.
    """

    message: Optional[StrictStr] = None

    code: Optional[StrictStr] = None

    error_code: Optional[StrictStr] = None

    request_id: Optional[StrictStr] = None

    __properties = ["message", "code", "error_code", "request_id"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorResponse:
        """Create an instance of ErrorResponse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorResponse:
        """Create an instance of ErrorResponse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ErrorResponse.model_validate(obj)

        _obj = ErrorResponse.model_validate(
            {
                "message": obj.get("message"),
                "code": obj.get("code"),
                "error_code": obj.get("error_code"),
                "request_id": obj.get("request_id"),
            }
        )

        return _obj


class ErrorResponseModel:
    def __init__(
        self,  # optional properties
        message: Optional[str] = None,
        code: Optional[str] = None,
        error_code: Optional[str] = None,
        request_id: Optional[str] = None,
    ):
        """A model object representing the ErrorResponse resource.

        Constructs an object of type ErrorResponse with the provided properties.

        Parameters
        __________
        message : str, optional
            Error message returned by the server
        code : str, optional
            Error code.
        error_code : str, optional
            Error code, same as `code` above. This property has been deprecated and will be removed in a future release, but is temporarily supported for for short-term backward compatibility.
        request_id : str, optional
            Unique request ID.
        """
        self.message = message
        self.code = code
        self.error_code = error_code
        self.request_id = request_id

    __properties = ["message", "code", "error_code", "request_id"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ErrorResponse(
            message=self.message,
            code=self.code,
            error_code=self.error_code,
            request_id=self.request_id,
        )

    @classmethod
    def _from_model(cls, model) -> ErrorResponseModel:
        return ErrorResponseModel(
            message=model.message,
            code=model.code,
            error_code=model.error_code,
            request_id=model.request_id,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a ErrorResponse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ErrorResponse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorResponseModel:
        """Create an instance of ErrorResponse from a dict.

        This method constructs a ErrorResponse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ErrorResponse
            A ErrorResponse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ErrorResponse.from_dict(obj))


ErrorResponse._model_class = ErrorResponseModel
