"""
Snowflake Warehouse API.

The Snowflake Warehouse API is a REST API that you can use to access, customize and manage virtual warehouse in a Snowflake account.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated


class Warehouse(BaseModel):
    """A model object representing the Warehouse resource.

    Constructs an object of type Warehouse with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    warehouse_type : str, optional
        Type of warehouse, possible types: STANDARD, SNOWPARK-OPTIMIZED
    warehouse_size : str, optional
        Size of warehouse, possible sizes: XSMALL, SMALL, MEDIUM, LARGE, XLARGE, XXLARGE, XXXLARGE, X4LARGE, X5LARGE, X6LARGE
    wait_for_completion : str, optional
        When resizing a warehouse, you can use this parameter to block the return of the ALTER WAREHOUSE command until the resize has finished provisioning all its compute resources
    max_cluster_count : int, optional
        Specifies the maximum number of clusters for a multi-cluster warehouse
    min_cluster_count : int, optional
        Specifies the minimum number of clusters for a multi-cluster warehouse
    scaling_policy : str, optional
        Scaling policy of warehouse, possible scaling policies: STANDARD, ECONOMY
    auto_suspend : int, optional
        time in seconds before auto suspend
    auto_resume : str, optional
        Specifies whether to automatically resume a warehouse when a SQL statement is submitted to it
    initially_suspended : str, optional
        Specifies whether the warehouse is created initially in the Suspended state
    resource_monitor : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    comment : str, optional
        Specifies a comment for the warehouse
    enable_query_acceleration : str, optional
        Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources
    query_acceleration_max_scale_factor : int, optional
        Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size
    max_concurrency_level : int, optional
        Object parameter that specifies the concurrency level for SQL statements executed by a warehouse cluster
    statement_queued_timeout_in_seconds : int, optional
        Object parameter that specifies the time, in seconds, a SQL statement can be queued on a warehouse before it is canceled by the system
    statement_timeout_in_seconds : int, optional
        Object parameter that specifies the time, in seconds, after which a running SQL statement  is canceled by the system
    type : str, optional
        [Deprecated] Type of warehouse, possible types: STANDARD, SNOWPARK-OPTIMIZED
    size : str, optional
        [Deprecated] names of size: X-Small, Small, Medium, Large, X-Large, 2X-Large, 3X-Large, 4X-Large, 5X-Large, 6X-Large
    state : str, optional
        The state of warehouse, possible states: STARTED, STARTING, DYNAMIC, SUSPENDED, RESIZING, RESUMING, SUSPENDING — **Read-only:** *any user-provided value will be ignored.*
    started_clusters : int, optional
        Number of clusters currently started — **Read-only:** *any user-provided value will be ignored.*
    running : int, optional
        Number of SQL statements that are being executed by the warehouse — **Read-only:** *any user-provided value will be ignored.*
    queued : int, optional
        Number of SQL statements that are queued for the warehouse — **Read-only:** *any user-provided value will be ignored.*
    is_default : bool, optional
        Whether the warehouse is the default for the current user — **Read-only:** *any user-provided value will be ignored.*
    is_current : bool, optional
        Whether the warehouse is in use for the session. Only one warehouse can be in use at a time for a session.  To specify or change the warehouse for a session, use the USE WAREHOUSE command — **Read-only:** *any user-provided value will be ignored.*
    available : str, optional
        Percentage of the warehouse compute resources that are provisioned and available — **Read-only:** *any user-provided value will be ignored.*
    provisioning : str, optional
        Percentage of the warehouse compute resources that are in the process of provisioning — **Read-only:** *any user-provided value will be ignored.*
    quiescing : str, optional
        Percentage of the warehouse compute resources that are executing SQL statements,  but will be shut down once the queries complete — **Read-only:** *any user-provided value will be ignored.*
    other : str, optional
        Percentage of the warehouse compute resources that are in a state other than available,  provisioning, or quiescing — **Read-only:** *any user-provided value will be ignored.*
    created_on : datetime, optional
        Date and time when the warehouse was created — **Read-only:** *any user-provided value will be ignored.*
    resumed_on : datetime, optional
        Date and time when the warehouse was last started or restarted — **Read-only:** *any user-provided value will be ignored.*
    updated_on : datetime, optional
        Date and time when the warehouse was last updated,  which includes changing any of the properties of the warehouse or changing the state (STARTED, SUSPENDED, RESIZING) of the warehouse — **Read-only:** *any user-provided value will be ignored.*
    owner : str, optional
        Role that owns the warehouse — **Read-only:** *any user-provided value will be ignored.*
    budget : str, optional
        Comment representing budget for warehouse — **Read-only:** *any user-provided value will be ignored.*
    kind : str, optional
        **Read-only:** *any user-provided value will be ignored.*
    owner_role_type : str, optional
        The type of role that owns the object — **Read-only:** *any user-provided value will be ignored.*
    warehouse_credit_limit : int, optional
        Credit limit that are can be executed by the warehouse.
    target_statement_size : str, optional
        Names of size: X-Small, Small, Medium, Large, X-Large, 2X-Large, 3X-Large, 4X-Large, 5X-Large, 6X-Large
    """

    name: Annotated[str, Field(strict=True)]

    warehouse_type: Optional[StrictStr] = None

    warehouse_size: Optional[StrictStr] = None

    wait_for_completion: Optional[StrictStr] = None

    max_cluster_count: Optional[StrictInt] = None

    min_cluster_count: Optional[StrictInt] = None

    scaling_policy: Optional[StrictStr] = None

    auto_suspend: Optional[StrictInt] = None

    auto_resume: Optional[StrictStr] = None

    initially_suspended: Optional[StrictStr] = None

    resource_monitor: Optional[Annotated[str, Field(strict=True)]] = None

    comment: Optional[StrictStr] = None

    enable_query_acceleration: Optional[StrictStr] = None

    query_acceleration_max_scale_factor: Optional[StrictInt] = None

    max_concurrency_level: Optional[StrictInt] = None

    statement_queued_timeout_in_seconds: Optional[StrictInt] = None

    statement_timeout_in_seconds: Optional[StrictInt] = None

    type: Optional[StrictStr] = None

    size: Optional[StrictStr] = None

    state: Optional[StrictStr] = None

    started_clusters: Optional[StrictInt] = None

    running: Optional[StrictInt] = None

    queued: Optional[StrictInt] = None

    is_default: Optional[StrictBool] = None

    is_current: Optional[StrictBool] = None

    available: Optional[StrictStr] = None

    provisioning: Optional[StrictStr] = None

    quiescing: Optional[StrictStr] = None

    other: Optional[StrictStr] = None

    created_on: Optional[datetime] = None

    resumed_on: Optional[datetime] = None

    updated_on: Optional[datetime] = None

    owner: Optional[StrictStr] = None

    budget: Optional[StrictStr] = None

    kind: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    warehouse_credit_limit: Optional[StrictInt] = None

    target_statement_size: Optional[StrictStr] = None

    __properties = [
        "name",
        "warehouse_type",
        "warehouse_size",
        "wait_for_completion",
        "max_cluster_count",
        "min_cluster_count",
        "scaling_policy",
        "auto_suspend",
        "auto_resume",
        "initially_suspended",
        "resource_monitor",
        "comment",
        "enable_query_acceleration",
        "query_acceleration_max_scale_factor",
        "max_concurrency_level",
        "statement_queued_timeout_in_seconds",
        "statement_timeout_in_seconds",
        "type",
        "size",
        "state",
        "started_clusters",
        "running",
        "queued",
        "is_default",
        "is_current",
        "available",
        "provisioning",
        "quiescing",
        "other",
        "created_on",
        "resumed_on",
        "updated_on",
        "owner",
        "budget",
        "kind",
        "owner_role_type",
        "warehouse_credit_limit",
        "target_statement_size",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("wait_for_completion")
    def wait_for_completion_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("true", "false"):
            raise ValueError("must validate the enum values ('true','false')")
        return v

    @field_validator("auto_resume")
    def auto_resume_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("true", "false"):
            raise ValueError("must validate the enum values ('true','false')")
        return v

    @field_validator("initially_suspended")
    def initially_suspended_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("true", "false"):
            raise ValueError("must validate the enum values ('true','false')")
        return v

    @field_validator("resource_monitor")
    def resource_monitor_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    @field_validator("enable_query_acceleration")
    def enable_query_acceleration_validate_enum(cls, v):
        if v is None:
            return v
        if v not in ("true", "false"):
            raise ValueError("must validate the enum values ('true','false')")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Warehouse:
        """Create an instance of Warehouse from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "state",
                    "started_clusters",
                    "running",
                    "queued",
                    "is_default",
                    "is_current",
                    "available",
                    "provisioning",
                    "quiescing",
                    "other",
                    "created_on",
                    "resumed_on",
                    "updated_on",
                    "owner",
                    "budget",
                    "kind",
                    "owner_role_type",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Warehouse:
        """Create an instance of Warehouse from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Warehouse.model_validate(obj)

        _obj = Warehouse.model_validate(
            {
                "name": obj.get("name"),
                "warehouse_type": obj.get("warehouse_type"),
                "warehouse_size": obj.get("warehouse_size"),
                "wait_for_completion": obj.get("wait_for_completion"),
                "max_cluster_count": obj.get("max_cluster_count"),
                "min_cluster_count": obj.get("min_cluster_count"),
                "scaling_policy": obj.get("scaling_policy"),
                "auto_suspend": obj.get("auto_suspend"),
                "auto_resume": obj.get("auto_resume"),
                "initially_suspended": obj.get("initially_suspended"),
                "resource_monitor": obj.get("resource_monitor"),
                "comment": obj.get("comment"),
                "enable_query_acceleration": obj.get("enable_query_acceleration"),
                "query_acceleration_max_scale_factor": obj.get("query_acceleration_max_scale_factor"),
                "max_concurrency_level": obj.get("max_concurrency_level"),
                "statement_queued_timeout_in_seconds": obj.get("statement_queued_timeout_in_seconds"),
                "statement_timeout_in_seconds": obj.get("statement_timeout_in_seconds"),
                "type": obj.get("type"),
                "size": obj.get("size"),
                "state": obj.get("state"),
                "started_clusters": obj.get("started_clusters"),
                "running": obj.get("running"),
                "queued": obj.get("queued"),
                "is_default": obj.get("is_default"),
                "is_current": obj.get("is_current"),
                "available": obj.get("available"),
                "provisioning": obj.get("provisioning"),
                "quiescing": obj.get("quiescing"),
                "other": obj.get("other"),
                "created_on": obj.get("created_on"),
                "resumed_on": obj.get("resumed_on"),
                "updated_on": obj.get("updated_on"),
                "owner": obj.get("owner"),
                "budget": obj.get("budget"),
                "kind": obj.get("kind"),
                "owner_role_type": obj.get("owner_role_type"),
                "warehouse_credit_limit": obj.get("warehouse_credit_limit"),
                "target_statement_size": obj.get("target_statement_size"),
            }
        )

        return _obj


class WarehouseModel:
    def __init__(
        self,
        name: str,
        # optional properties
        warehouse_type: Optional[str] = None,
        warehouse_size: Optional[str] = None,
        wait_for_completion: Optional[str] = None,
        max_cluster_count: Optional[int] = None,
        min_cluster_count: Optional[int] = None,
        scaling_policy: Optional[str] = None,
        auto_suspend: Optional[int] = None,
        auto_resume: Optional[str] = None,
        initially_suspended: Optional[str] = None,
        resource_monitor: Optional[str] = None,
        comment: Optional[str] = None,
        enable_query_acceleration: Optional[str] = None,
        query_acceleration_max_scale_factor: Optional[int] = None,
        max_concurrency_level: Optional[int] = None,
        statement_queued_timeout_in_seconds: Optional[int] = None,
        statement_timeout_in_seconds: Optional[int] = None,
        type: Optional[str] = None,
        size: Optional[str] = None,
        state: Optional[str] = None,
        started_clusters: Optional[int] = None,
        running: Optional[int] = None,
        queued: Optional[int] = None,
        is_default: Optional[bool] = None,
        is_current: Optional[bool] = None,
        available: Optional[str] = None,
        provisioning: Optional[str] = None,
        quiescing: Optional[str] = None,
        other: Optional[str] = None,
        created_on: Optional[datetime] = None,
        resumed_on: Optional[datetime] = None,
        updated_on: Optional[datetime] = None,
        owner: Optional[str] = None,
        budget: Optional[str] = None,
        kind: Optional[str] = None,
        owner_role_type: Optional[str] = None,
        warehouse_credit_limit: Optional[int] = None,
        target_statement_size: Optional[str] = None,
    ):
        """A model object representing the Warehouse resource.

        Constructs an object of type Warehouse with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        warehouse_type : str, optional
            Type of warehouse, possible types: STANDARD, SNOWPARK-OPTIMIZED
        warehouse_size : str, optional
            Size of warehouse, possible sizes: XSMALL, SMALL, MEDIUM, LARGE, XLARGE, XXLARGE, XXXLARGE, X4LARGE, X5LARGE, X6LARGE
        wait_for_completion : str, optional
            When resizing a warehouse, you can use this parameter to block the return of the ALTER WAREHOUSE command until the resize has finished provisioning all its compute resources
        max_cluster_count : int, optional
            Specifies the maximum number of clusters for a multi-cluster warehouse
        min_cluster_count : int, optional
            Specifies the minimum number of clusters for a multi-cluster warehouse
        scaling_policy : str, optional
            Scaling policy of warehouse, possible scaling policies: STANDARD, ECONOMY
        auto_suspend : int, optional
            time in seconds before auto suspend
        auto_resume : str, optional
            Specifies whether to automatically resume a warehouse when a SQL statement is submitted to it
        initially_suspended : str, optional
            Specifies whether the warehouse is created initially in the Suspended state
        resource_monitor : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        comment : str, optional
            Specifies a comment for the warehouse
        enable_query_acceleration : str, optional
            Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources
        query_acceleration_max_scale_factor : int, optional
            Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size
        max_concurrency_level : int, optional
            Object parameter that specifies the concurrency level for SQL statements executed by a warehouse cluster
        statement_queued_timeout_in_seconds : int, optional
            Object parameter that specifies the time, in seconds, a SQL statement can be queued on a warehouse before it is canceled by the system
        statement_timeout_in_seconds : int, optional
            Object parameter that specifies the time, in seconds, after which a running SQL statement  is canceled by the system
        type : str, optional
            [Deprecated] Type of warehouse, possible types: STANDARD, SNOWPARK-OPTIMIZED
        size : str, optional
            [Deprecated] names of size: X-Small, Small, Medium, Large, X-Large, 2X-Large, 3X-Large, 4X-Large, 5X-Large, 6X-Large
        state : str, optional
            The state of warehouse, possible states: STARTED, STARTING, DYNAMIC, SUSPENDED, RESIZING, RESUMING, SUSPENDING
        started_clusters : int, optional
            Number of clusters currently started.
        running : int, optional
            Number of SQL statements that are being executed by the warehouse.
        queued : int, optional
            Number of SQL statements that are queued for the warehouse.
        is_default : bool, optional
            Whether the warehouse is the default for the current user.
        is_current : bool, optional
            Whether the warehouse is in use for the session. Only one warehouse can be in use at a time for a session.  To specify or change the warehouse for a session, use the USE WAREHOUSE command.
        available : str, optional
            Percentage of the warehouse compute resources that are provisioned and available.
        provisioning : str, optional
            Percentage of the warehouse compute resources that are in the process of provisioning.
        quiescing : str, optional
            Percentage of the warehouse compute resources that are executing SQL statements,  but will be shut down once the queries complete.
        other : str, optional
            Percentage of the warehouse compute resources that are in a state other than available,  provisioning, or quiescing.
        created_on : datetime, optional
            Date and time when the warehouse was created.
        resumed_on : datetime, optional
            Date and time when the warehouse was last started or restarted.
        updated_on : datetime, optional
            Date and time when the warehouse was last updated,  which includes changing any of the properties of the warehouse or changing the state (STARTED, SUSPENDED, RESIZING) of the warehouse.
        owner : str, optional
            Role that owns the warehouse.
        budget : str, optional
            Comment representing budget for warehouse.
        kind : str, optional

        owner_role_type : str, optional
            The type of role that owns the object.
        warehouse_credit_limit : int, optional
            Credit limit that are can be executed by the warehouse.
        target_statement_size : str, optional
            Names of size: X-Small, Small, Medium, Large, X-Large, 2X-Large, 3X-Large, 4X-Large, 5X-Large, 6X-Large
        """
        self.name = name
        self.warehouse_type = warehouse_type
        self.warehouse_size = warehouse_size
        self.wait_for_completion = wait_for_completion
        self.max_cluster_count = max_cluster_count
        self.min_cluster_count = min_cluster_count
        self.scaling_policy = scaling_policy
        self.auto_suspend = auto_suspend
        self.auto_resume = auto_resume
        self.initially_suspended = initially_suspended
        self.resource_monitor = resource_monitor
        self.comment = comment
        self.enable_query_acceleration = enable_query_acceleration
        self.query_acceleration_max_scale_factor = query_acceleration_max_scale_factor
        self.max_concurrency_level = max_concurrency_level
        self.statement_queued_timeout_in_seconds = statement_queued_timeout_in_seconds
        self.statement_timeout_in_seconds = statement_timeout_in_seconds
        self.type = type
        self.size = size
        self.state = state
        self.started_clusters = started_clusters
        self.running = running
        self.queued = queued
        self.is_default = is_default
        self.is_current = is_current
        self.available = available
        self.provisioning = provisioning
        self.quiescing = quiescing
        self.other = other
        self.created_on = created_on
        self.resumed_on = resumed_on
        self.updated_on = updated_on
        self.owner = owner
        self.budget = budget
        self.kind = kind
        self.owner_role_type = owner_role_type
        self.warehouse_credit_limit = warehouse_credit_limit
        self.target_statement_size = target_statement_size

    __properties = [
        "name",
        "warehouse_type",
        "warehouse_size",
        "wait_for_completion",
        "max_cluster_count",
        "min_cluster_count",
        "scaling_policy",
        "auto_suspend",
        "auto_resume",
        "initially_suspended",
        "resource_monitor",
        "comment",
        "enable_query_acceleration",
        "query_acceleration_max_scale_factor",
        "max_concurrency_level",
        "statement_queued_timeout_in_seconds",
        "statement_timeout_in_seconds",
        "type",
        "size",
        "state",
        "started_clusters",
        "running",
        "queued",
        "is_default",
        "is_current",
        "available",
        "provisioning",
        "quiescing",
        "other",
        "created_on",
        "resumed_on",
        "updated_on",
        "owner",
        "budget",
        "kind",
        "owner_role_type",
        "warehouse_credit_limit",
        "target_statement_size",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Warehouse(
            name=self.name,
            warehouse_type=self.warehouse_type,
            warehouse_size=self.warehouse_size,
            wait_for_completion=self.wait_for_completion,
            max_cluster_count=self.max_cluster_count,
            min_cluster_count=self.min_cluster_count,
            scaling_policy=self.scaling_policy,
            auto_suspend=self.auto_suspend,
            auto_resume=self.auto_resume,
            initially_suspended=self.initially_suspended,
            resource_monitor=self.resource_monitor,
            comment=self.comment,
            enable_query_acceleration=self.enable_query_acceleration,
            query_acceleration_max_scale_factor=self.query_acceleration_max_scale_factor,
            max_concurrency_level=self.max_concurrency_level,
            statement_queued_timeout_in_seconds=self.statement_queued_timeout_in_seconds,
            statement_timeout_in_seconds=self.statement_timeout_in_seconds,
            type=self.type,
            size=self.size,
            state=self.state,
            started_clusters=self.started_clusters,
            running=self.running,
            queued=self.queued,
            is_default=self.is_default,
            is_current=self.is_current,
            available=self.available,
            provisioning=self.provisioning,
            quiescing=self.quiescing,
            other=self.other,
            created_on=self.created_on,
            resumed_on=self.resumed_on,
            updated_on=self.updated_on,
            owner=self.owner,
            budget=self.budget,
            kind=self.kind,
            owner_role_type=self.owner_role_type,
            warehouse_credit_limit=self.warehouse_credit_limit,
            target_statement_size=self.target_statement_size,
        )

    @classmethod
    def _from_model(cls, model) -> WarehouseModel:
        return WarehouseModel(
            name=model.name,
            warehouse_type=model.warehouse_type,
            warehouse_size=model.warehouse_size,
            wait_for_completion=model.wait_for_completion,
            max_cluster_count=model.max_cluster_count,
            min_cluster_count=model.min_cluster_count,
            scaling_policy=model.scaling_policy,
            auto_suspend=model.auto_suspend,
            auto_resume=model.auto_resume,
            initially_suspended=model.initially_suspended,
            resource_monitor=model.resource_monitor,
            comment=model.comment,
            enable_query_acceleration=model.enable_query_acceleration,
            query_acceleration_max_scale_factor=model.query_acceleration_max_scale_factor,
            max_concurrency_level=model.max_concurrency_level,
            statement_queued_timeout_in_seconds=model.statement_queued_timeout_in_seconds,
            statement_timeout_in_seconds=model.statement_timeout_in_seconds,
            type=model.type,
            size=model.size,
            state=model.state,
            started_clusters=model.started_clusters,
            running=model.running,
            queued=model.queued,
            is_default=model.is_default,
            is_current=model.is_current,
            available=model.available,
            provisioning=model.provisioning,
            quiescing=model.quiescing,
            other=model.other,
            created_on=model.created_on,
            resumed_on=model.resumed_on,
            updated_on=model.updated_on,
            owner=model.owner,
            budget=model.budget,
            kind=model.kind,
            owner_role_type=model.owner_role_type,
            warehouse_credit_limit=model.warehouse_credit_limit,
            target_statement_size=model.target_statement_size,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Warehouse.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Warehouse object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> WarehouseModel:
        """Create an instance of Warehouse from a dict.

        This method constructs a Warehouse object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Warehouse
            A Warehouse object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Warehouse.from_dict(obj))


Warehouse._model_class = WarehouseModel
