"""
Snowflake Alert API.

The Snowflake Alert API is a REST API that you can use to access, update, and perform certain actions on Alert resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr

from snowflake.core.alert._generated.models.point_of_time import PointOfTime, PointOfTimeModel


class AlertClone(BaseModel):
    """A model object representing the AlertClone resource.

    Constructs an object of type AlertClone with the provided properties.

    Parameters
    __________
    name : str
        Name of the alert
    point_of_time : PointOfTime, optional
    """

    name: StrictStr

    point_of_time: Optional[PointOfTime] = None

    __properties = ["name", "point_of_time"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AlertClone:
        """Create an instance of AlertClone from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # override the default output from pydantic by calling `to_dict()` of point_of_time
        if self.point_of_time:
            _dict["point_of_time"] = self.point_of_time.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AlertClone:
        """Create an instance of AlertClone from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AlertClone.model_validate(obj)

        _obj = AlertClone.model_validate(
            {
                "name": obj.get("name"),
                "point_of_time": PointOfTime.from_dict(obj.get("point_of_time"))
                if obj.get("point_of_time") is not None
                else None,
            }
        )

        return _obj


class AlertCloneModel:
    def __init__(
        self,
        name: str,
        # optional properties
        point_of_time: Optional[PointOfTime] = None,
    ):
        """A model object representing the AlertClone resource.

        Constructs an object of type AlertClone with the provided properties.

        Parameters
        __________
        name : str
            Name of the alert
        point_of_time : PointOfTime, optional
        """
        self.name = name
        self.point_of_time = point_of_time

    __properties = ["name", "point_of_time"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AlertClone(
            name=self.name,
            point_of_time=self.point_of_time._to_model() if self.point_of_time is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> AlertCloneModel:
        return AlertCloneModel(
            name=model.name,
            point_of_time=PointOfTimeModel._from_model(model.point_of_time) if model.point_of_time else None,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a AlertClone.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AlertClone object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AlertCloneModel:
        """Create an instance of AlertClone from a dict.

        This method constructs a AlertClone object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AlertClone
            A AlertClone object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AlertClone.from_dict(obj))


AlertClone._model_class = AlertCloneModel
