"""
Snowflake Catalog Integration API.

The Snowflake Catalog Integration API is a REST API that you can use to access, update, and perform certain actions on Catalog Integration resource in a Snowflake database.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any

from pydantic import ConfigDict

from snowflake.core.catalog_integration._generated.models.catalog import Catalog


class ObjectStore(Catalog):
    """A model object representing the ObjectStore resource.

    Constructs an object of type ObjectStore with the provided properties.

    Parameters
    __________
    """

    __properties = ["catalog_source"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ObjectStore:
        """Create an instance of ObjectStore from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        _dict["catalog_source"] = Catalog.get_child_model_discriminator_value("ObjectStore")

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ObjectStore:
        """Create an instance of ObjectStore from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ObjectStore.model_validate(obj)

        _obj = ObjectStore.model_validate({})

        return _obj


class ObjectStoreModel(Catalog):
    def __init__(
        self,  # optional properties
    ):
        """A model object representing the ObjectStore resource.

        Constructs an object of type ObjectStore with the provided properties.

        Parameters
        __________
        """
        super().__init__()

    __properties = ["catalog_source"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ObjectStore()

    @classmethod
    def _from_model(cls, model) -> ObjectStoreModel:
        return ObjectStoreModel()

    def to_dict(self):
        """Create a dictionary of the properties from a ObjectStore.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ObjectStore object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ObjectStoreModel:
        """Create an instance of ObjectStore from a dict.

        This method constructs a ObjectStore object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ObjectStore
            A ObjectStore object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ObjectStore.from_dict(obj))


ObjectStore._model_class = ObjectStoreModel
