"""
Snowflake Compute Pools API.

The Snowflake Compute Pools API is a REST API that you can use to access, update, and perform common actions on Compute Pool resources.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

import warnings

from typing import TYPE_CHECKING, Iterable, Iterator, Optional, TypeVar, Union

from snowflake.core._common import AccountObjectCollectionParent, CreateMode, ObjectReferenceMixin
from snowflake.core._generated.api_client import StoredProcApiClient
from snowflake.core._internal.telemetry import api_telemetry
from snowflake.core._operation import PollingOperation, PollingOperations
from snowflake.core._utils import get_function_name_with_args, replace_function_name_in_name_with_args
from snowflake.core.compute_pool._generated.models.compute_pool import ComputePool
from snowflake.core.compute_pool._generated.models.compute_pool_instance_family import ComputePoolInstanceFamily

from .compute_pool_api import ComputePoolApi


if TYPE_CHECKING:
    from snowflake.core import Root


T = TypeVar("T")


class ComputePoolCollectionBase(AccountObjectCollectionParent["ComputePoolResource"]):
    _identifier_requires_args: bool = False

    def __init__(self, root: "Root", resource_class: type[T]) -> None:
        super().__init__(root, resource_class)
        self._api = ComputePoolApi(
            root=self.root, resource_class=self._ref_class, sproc_client=StoredProcApiClient(root=self.root)
        )

    @api_telemetry
    def create(
        self,
        compute_pool: ComputePool,
        mode: Optional[Union[CreateMode, str]] = None,
        initially_suspended: Optional[bool] = None,
    ) -> "ComputePoolResource":  # noqa: F821
        """Creates a compute pool.

        Parameters
        __________
        compute_pool: ComputePool
             (required)
        mode: Union[CreateMode, str]
             Parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        initially_suspended: bool
             Specifies whether the compute pool is created initially in the suspended state.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        self._api.create_compute_pool(
            compute_pool=compute_pool,
            create_mode=mode,
            initially_suspended=initially_suspended,
            async_req=False,
        )
        if self._identifier_requires_args:
            return self._ref_class(get_function_name_with_args(compute_pool), self)
        return self._ref_class(compute_pool.name, self)

    @api_telemetry
    def create_async(
        self,
        compute_pool: ComputePool,
        mode: Optional[Union[CreateMode, str]] = None,
        initially_suspended: Optional[bool] = None,
    ) -> PollingOperation["ComputePoolResource"]:  # noqa: F821
        """An asynchronous version of :func:`create`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if isinstance(mode, str):
            mode = CreateMode[mode].value

        future = self._api.create_compute_pool(
            compute_pool=compute_pool,
            create_mode=mode,
            initially_suspended=initially_suspended,
            async_req=True,
        )
        if self._identifier_requires_args:
            return PollingOperation(future, lambda _: self._ref_class(get_function_name_with_args(compute_pool), self))
        return PollingOperation(
            future,
            lambda _: self._ref_class(compute_pool if isinstance(compute_pool, str) else compute_pool.name, self),
        )

    @api_telemetry
    def iter(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        show_limit: Optional[int] = None,
    ) -> Iterator[ComputePool]:
        """Lists compute pools.

        Parameters
        __________
        like: str
             Parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        starts_with: str
             Parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        limit: int
             Parameter to limit the maximum number of rows returned by a command.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        resources = self._api.list_compute_pools(
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            async_req=False,
        )
        return iter(resources)

    @api_telemetry
    def iter_async(
        self,
        *,
        like: Optional[str] = None,
        starts_with: Optional[str] = None,
        limit: Optional[int] = None,
        show_limit: Optional[int] = None,
    ) -> PollingOperation[Iterator[ComputePool]]:
        """An asynchronous version of :func:`iter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if show_limit is not None:
            if limit is not None:
                raise ValueError("Cannot specify both 'limit' and 'show_limit'. Use only one of them.")
            warnings.warn(DeprecationWarning("'show_limit' is deprecated, use 'limit' instead."))  # noqa: B028
            limit = show_limit

        future = self._api.list_compute_pools(
            like=like,
            starts_with=starts_with,
            show_limit=limit,
            async_req=True,
        )

        return PollingOperations.iterator(future)


class ComputePoolResourceBase(ObjectReferenceMixin["ComputePoolCollection"]):
    _collection_class: ComputePoolCollectionBase
    _identifier_requires_args: bool = False
    _plural_name: str

    def __init__(self, name: str, collection_class: ComputePoolCollectionBase) -> None:
        self.collection = collection_class
        if self._identifier_requires_args:
            self.name_with_args = name
        else:
            self.name = name

    @api_telemetry
    def create_or_alter(
        self,
        compute_pool: ComputePool,
    ) -> None:
        """Create a (or alter an existing) compute pool.

        Parameters
        __________
        compute_pool: ComputePool
             (required)
        """
        if self._identifier.lower() != compute_pool.name.lower():
            raise ValueError(
                "Cannot call create_or_alter on a resource with a different name than the "
                "one specified in the compute_pool argument."
            )
        self.collection._api.create_or_alter_compute_pool(
            self._identifier,
            compute_pool=compute_pool,
            async_req=False,
        )

    @api_telemetry
    def create_or_alter_async(
        self,
        compute_pool: ComputePool,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`create_or_alter`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        if self._identifier.lower() != compute_pool.name.lower():
            raise ValueError(
                "Cannot call create_or_alter on a resource with a different name than the "
                "one specified in the compute_pool argument."
            )
        future = self.collection._api.create_or_alter_compute_pool(
            self._identifier,
            compute_pool=compute_pool,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def fetch(
        self,
    ) -> ComputePool:
        """Fetches a compute pool.

        Parameters
        __________
        """
        return self.collection._api.fetch_compute_pool(
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def fetch_async(
        self,
    ) -> PollingOperation[ComputePool]:
        """An asynchronous version of :func:`fetch`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.fetch_compute_pool(
            self._identifier,
            async_req=True,
        )

        return PollingOperations.identity(future)

    @api_telemetry
    def list_instance_families(
        self,
    ) -> Iterable[ComputePoolInstanceFamily]:
        """Lists available compute pool instance families.

        Parameters
        __________
        """
        return self.collection._api.list_compute_pool_instance_families(
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def list_instance_families_async(
        self,
    ) -> PollingOperation[Iterable[ComputePoolInstanceFamily]]:
        """An asynchronous version of :func:`list_instance_families`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.list_compute_pool_instance_families(
            self._identifier,
            async_req=True,
        )

        return PollingOperations.iterator(future)

    @api_telemetry
    def resume(
        self,
    ) -> None:
        """Resumes a suspended compute pool.

        Parameters
        __________
        """
        self.collection._api.resume_compute_pool(
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def resume_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`resume`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.resume_compute_pool(
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def stop_all_services(
        self,
    ) -> None:
        """Stops all services on the compute pool.

        Parameters
        __________
        """
        self.collection._api.stop_all_services_in_compute_pool(
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def stop_all_services_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`stop_all_services`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.stop_all_services_in_compute_pool(
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def suspend(
        self,
    ) -> None:
        """Suspends an active compute pool.

        Parameters
        __________
        """
        self.collection._api.suspend_compute_pool(
            self._identifier,
            async_req=False,
        )

    @api_telemetry
    def suspend_async(
        self,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`suspend`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.suspend_compute_pool(
            self._identifier,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @api_telemetry
    def drop(
        self,
        if_exists: Optional[bool] = None,
    ) -> None:
        """Deletes a compute pool.

        Parameters
        __________
        if_exists: bool
             Parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        """
        self.collection._api.delete_compute_pool(
            self._identifier,
            if_exists=if_exists,
            async_req=False,
        )

    @api_telemetry
    def drop_async(
        self,
        if_exists: Optional[bool] = None,
    ) -> PollingOperation[None]:
        """An asynchronous version of :func:`drop`.

        Refer to :class:`~snowflake.core.PollingOperation` for more information on asynchronous execution and
        the return type.
        """
        future = self.collection._api.delete_compute_pool(
            self._identifier,
            if_exists=if_exists,
            async_req=True,
        )
        return PollingOperations.empty(future)

    @property
    def _identifier(self) -> str:
        """Get the identifier for this resource."""
        if self._identifier_requires_args:
            return self.name_with_args
        return self.name

    def _set_new_name(self, target_name: str) -> None:
        """Set a new name for the resource."""
        if self._identifier_requires_args:
            old_name = self.name_with_args
            self.name_with_args = replace_function_name_in_name_with_args(self.name_with_args, target_name)
        else:
            old_name = self.name
            self.name = target_name

        # Update the collection reference to point to the new name
        self.collection.update_reference(old_name=old_name, new_name=self._identifier, resource=self)
