"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, StrictStr


class SemanticModelObject(BaseModel):
    """A model object representing the SemanticModelObject resource.

    Constructs an object of type SemanticModelObject with the provided properties.

    Parameters
    __________
    semantic_model_file : str, optional
        The path to a file stored in a Snowflake Stage holding the semantic model yaml. Must be a fully qualified stage url
    semantic_view : str, optional
        The name of the Snowflake native semantic model object
    inline_semantic_model : str, optional
        A string containing the entire semantic model yaml
    """

    semantic_model_file: Optional[StrictStr] = None

    semantic_view: Optional[StrictStr] = None

    inline_semantic_model: Optional[StrictStr] = None

    __properties = ["semantic_model_file", "semantic_view", "inline_semantic_model"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SemanticModelObject:
        """Create an instance of SemanticModelObject from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelObject:
        """Create an instance of SemanticModelObject from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SemanticModelObject.model_validate(obj)

        _obj = SemanticModelObject.model_validate(
            {
                "semantic_model_file": obj.get("semantic_model_file"),
                "semantic_view": obj.get("semantic_view"),
                "inline_semantic_model": obj.get("inline_semantic_model"),
            }
        )

        return _obj


class SemanticModelObjectModel:
    def __init__(
        self,  # optional properties
        semantic_model_file: Optional[str] = None,
        semantic_view: Optional[str] = None,
        inline_semantic_model: Optional[str] = None,
    ):
        """A model object representing the SemanticModelObject resource.

        Constructs an object of type SemanticModelObject with the provided properties.

        Parameters
        __________
        semantic_model_file : str, optional
            The path to a file stored in a Snowflake Stage holding the semantic model yaml. Must be a fully qualified stage url
        semantic_view : str, optional
            The name of the Snowflake native semantic model object
        inline_semantic_model : str, optional
            A string containing the entire semantic model yaml
        """
        self.semantic_model_file = semantic_model_file
        self.semantic_view = semantic_view
        self.inline_semantic_model = inline_semantic_model

    __properties = ["semantic_model_file", "semantic_view", "inline_semantic_model"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return SemanticModelObject(
            semantic_model_file=self.semantic_model_file,
            semantic_view=self.semantic_view,
            inline_semantic_model=self.inline_semantic_model,
        )

    @classmethod
    def _from_model(cls, model) -> SemanticModelObjectModel:
        return SemanticModelObjectModel(
            semantic_model_file=model.semantic_model_file,
            semantic_view=model.semantic_view,
            inline_semantic_model=model.inline_semantic_model,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a SemanticModelObject.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the SemanticModelObject object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> SemanticModelObjectModel:
        """Create an instance of SemanticModelObject from a dict.

        This method constructs a SemanticModelObject object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        SemanticModelObject
            A SemanticModelObject object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(SemanticModelObject.from_dict(obj))


SemanticModelObject._model_class = SemanticModelObjectModel
