"""
Cortex Analyst API.

The Snowflake Cortex Analyst API is a REST API that allows end user to chat with their data leveraging semantic models to generate SQL queries.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401

from typing import Any, List

from pydantic import BaseModel, ConfigDict, Field, StrictStr


class TableColumns(BaseModel):
    """A model object representing the TableColumns resource.

    Constructs an object of type TableColumns with the provided properties.

    Parameters
    __________
    database : str
        Database name
    var_schema : str
        Schema name
    table : str
        Table name
    column_names : list[str]
    """

    database: StrictStr

    var_schema: StrictStr = Field(alias="schema")

    table: StrictStr

    column_names: List[StrictStr]

    __properties = ["database", "schema", "table", "column_names"]

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableColumns:
        """Create an instance of TableColumns from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableColumns:
        """Create an instance of TableColumns from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableColumns.model_validate(obj)

        _obj = TableColumns.model_validate(
            {
                "database": obj.get("database"),
                "var_schema": obj.get("schema"),
                "table": obj.get("table"),
                "column_names": obj.get("column_names"),
            }
        )

        return _obj


class TableColumnsModel:
    def __init__(
        self,
        database: str,
        var_schema: str,
        table: str,
        column_names: list[str],
        # optional properties
    ):
        """A model object representing the TableColumns resource.

        Constructs an object of type TableColumns with the provided properties.

        Parameters
        __________
        database : str
            Database name
        var_schema : str
            Schema name
        table : str
            Table name
        column_names : list[str]
        """
        self.database = database
        self.var_schema = var_schema
        self.table = table
        self.column_names = column_names

    __properties = ["database", "schema", "table", "column_names"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableColumns(
            database=self.database,
            var_schema=self.var_schema,
            table=self.table,
            column_names=self.column_names,
        )

    @classmethod
    def _from_model(cls, model) -> TableColumnsModel:
        return TableColumnsModel(
            database=model.database,
            var_schema=model.var_schema,
            table=model.table,
            column_names=model.column_names,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a TableColumns.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableColumns object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableColumnsModel:
        """Create an instance of TableColumns from a dict.

        This method constructs a TableColumns object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableColumns
            A TableColumns object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableColumns.from_dict(obj))


TableColumns._model_class = TableColumnsModel
